/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the search status of a log stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchedLogStream implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchedLogStream.Builder, SearchedLogStream> {
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logStreamName").getter(getter(SearchedLogStream::logStreamName)).setter(setter(Builder::logStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()).build();

    private static final SdkField<Boolean> SEARCHED_COMPLETELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("searchedCompletely").getter(getter(SearchedLogStream::searchedCompletely))
            .setter(setter(Builder::searchedCompletely))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchedCompletely").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_STREAM_NAME_FIELD,
            SEARCHED_COMPLETELY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logStreamName;

    private final Boolean searchedCompletely;

    private SearchedLogStream(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.searchedCompletely = builder.searchedCompletely;
    }

    /**
     * <p>
     * The name of the log stream.
     * </p>
     * 
     * @return The name of the log stream.
     */
    public final String logStreamName() {
        return logStreamName;
    }

    /**
     * <p>
     * Indicates whether all the events in this log stream were searched.
     * </p>
     * 
     * @return Indicates whether all the events in this log stream were searched.
     */
    public final Boolean searchedCompletely() {
        return searchedCompletely;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(searchedCompletely());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchedLogStream)) {
            return false;
        }
        SearchedLogStream other = (SearchedLogStream) obj;
        return Objects.equals(logStreamName(), other.logStreamName())
                && Objects.equals(searchedCompletely(), other.searchedCompletely());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchedLogStream").add("LogStreamName", logStreamName())
                .add("SearchedCompletely", searchedCompletely()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logStreamName":
            return Optional.ofNullable(clazz.cast(logStreamName()));
        case "searchedCompletely":
            return Optional.ofNullable(clazz.cast(searchedCompletely()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchedLogStream, T> g) {
        return obj -> g.apply((SearchedLogStream) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchedLogStream> {
        /**
         * <p>
         * The name of the log stream.
         * </p>
         * 
         * @param logStreamName
         *        The name of the log stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);

        /**
         * <p>
         * Indicates whether all the events in this log stream were searched.
         * </p>
         * 
         * @param searchedCompletely
         *        Indicates whether all the events in this log stream were searched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedCompletely(Boolean searchedCompletely);
    }

    static final class BuilderImpl implements Builder {
        private String logStreamName;

        private Boolean searchedCompletely;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchedLogStream model) {
            logStreamName(model.logStreamName);
            searchedCompletely(model.searchedCompletely);
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final Boolean getSearchedCompletely() {
            return searchedCompletely;
        }

        public final void setSearchedCompletely(Boolean searchedCompletely) {
            this.searchedCompletely = searchedCompletely;
        }

        @Override
        public final Builder searchedCompletely(Boolean searchedCompletely) {
            this.searchedCompletely = searchedCompletely;
            return this;
        }

        @Override
        public SearchedLogStream build() {
            return new SearchedLogStream(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
