/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteQueryDefinitionRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, DeleteQueryDefinitionRequest> {
    private static final SdkField<String> QUERY_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryDefinitionId").getter(DeleteQueryDefinitionRequest.getter(DeleteQueryDefinitionRequest::queryDefinitionId)).setter(DeleteQueryDefinitionRequest.setter(Builder::queryDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryDefinitionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_DEFINITION_ID_FIELD));
    private final String queryDefinitionId;

    private DeleteQueryDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.queryDefinitionId = builder.queryDefinitionId;
    }

    public String queryDefinitionId() {
        return this.queryDefinitionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryDefinitionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteQueryDefinitionRequest)) {
            return false;
        }
        DeleteQueryDefinitionRequest other = (DeleteQueryDefinitionRequest)((Object)obj);
        return Objects.equals(this.queryDefinitionId(), other.queryDefinitionId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteQueryDefinitionRequest").add("QueryDefinitionId", (Object)this.queryDefinitionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queryDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.queryDefinitionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteQueryDefinitionRequest, T> g) {
        return obj -> g.apply((DeleteQueryDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String queryDefinitionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteQueryDefinitionRequest model) {
            super(model);
            this.queryDefinitionId(model.queryDefinitionId);
        }

        public final String getQueryDefinitionId() {
            return this.queryDefinitionId;
        }

        @Override
        public final Builder queryDefinitionId(String queryDefinitionId) {
            this.queryDefinitionId = queryDefinitionId;
            return this;
        }

        public final void setQueryDefinitionId(String queryDefinitionId) {
            this.queryDefinitionId = queryDefinitionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteQueryDefinitionRequest build() {
            return new DeleteQueryDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteQueryDefinitionRequest> {
        public Builder queryDefinitionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

