/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricFilterMatchRecord;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricFilterMatchesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestMetricFilterResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, TestMetricFilterResponse> {
    private static final SdkField<List<MetricFilterMatchRecord>> MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("matches").getter(TestMetricFilterResponse.getter(TestMetricFilterResponse::matches)).setter(TestMetricFilterResponse.setter(Builder::matches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricFilterMatchRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCHES_FIELD));
    private final List<MetricFilterMatchRecord> matches;

    private TestMetricFilterResponse(BuilderImpl builder) {
        super(builder);
        this.matches = builder.matches;
    }

    public boolean hasMatches() {
        return this.matches != null && !(this.matches instanceof SdkAutoConstructList);
    }

    public List<MetricFilterMatchRecord> matches() {
        return this.matches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.matches());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestMetricFilterResponse)) {
            return false;
        }
        TestMetricFilterResponse other = (TestMetricFilterResponse)((Object)obj);
        return Objects.equals(this.matches(), other.matches());
    }

    public String toString() {
        return ToString.builder((String)"TestMetricFilterResponse").add("Matches", this.matches()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "matches": {
                return Optional.ofNullable(clazz.cast(this.matches()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestMetricFilterResponse, T> g) {
        return obj -> g.apply((TestMetricFilterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<MetricFilterMatchRecord> matches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestMetricFilterResponse model) {
            super(model);
            this.matches(model.matches);
        }

        public final Collection<MetricFilterMatchRecord.Builder> getMatches() {
            return this.matches != null ? (Collection)this.matches.stream().map(MetricFilterMatchRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder matches(Collection<MetricFilterMatchRecord> matches) {
            this.matches = MetricFilterMatchesCopier.copy(matches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matches(MetricFilterMatchRecord ... matches) {
            this.matches(Arrays.asList(matches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matches(Consumer<MetricFilterMatchRecord.Builder> ... matches) {
            this.matches(Stream.of(matches).map(c -> (MetricFilterMatchRecord)((MetricFilterMatchRecord.Builder)MetricFilterMatchRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMatches(Collection<MetricFilterMatchRecord.BuilderImpl> matches) {
            this.matches = MetricFilterMatchesCopier.copyFromBuilder(matches);
        }

        @Override
        public TestMetricFilterResponse build() {
            return new TestMetricFilterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestMetricFilterResponse> {
        public Builder matches(Collection<MetricFilterMatchRecord> var1);

        public Builder matches(MetricFilterMatchRecord ... var1);

        public Builder matches(Consumer<MetricFilterMatchRecord.Builder> ... var1);
    }
}

