/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupField;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLogGroupFieldsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, GetLogGroupFieldsResponse> {
    private static final SdkField<List<LogGroupField>> LOG_GROUP_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetLogGroupFieldsResponse.getter(GetLogGroupFieldsResponse::logGroupFields)).setter(GetLogGroupFieldsResponse.setter(Builder::logGroupFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogGroupField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_FIELDS_FIELD));
    private final List<LogGroupField> logGroupFields;

    private GetLogGroupFieldsResponse(BuilderImpl builder) {
        super(builder);
        this.logGroupFields = builder.logGroupFields;
    }

    public boolean hasLogGroupFields() {
        return this.logGroupFields != null && !(this.logGroupFields instanceof SdkAutoConstructList);
    }

    public List<LogGroupField> logGroupFields() {
        return this.logGroupFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupFields());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogGroupFieldsResponse)) {
            return false;
        }
        GetLogGroupFieldsResponse other = (GetLogGroupFieldsResponse)((Object)obj);
        return Objects.equals(this.logGroupFields(), other.logGroupFields());
    }

    public String toString() {
        return ToString.builder((String)"GetLogGroupFieldsResponse").add("LogGroupFields", this.logGroupFields()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupFields": {
                return Optional.ofNullable(clazz.cast(this.logGroupFields()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLogGroupFieldsResponse, T> g) {
        return obj -> g.apply((GetLogGroupFieldsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<LogGroupField> logGroupFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogGroupFieldsResponse model) {
            super(model);
            this.logGroupFields(model.logGroupFields);
        }

        public final Collection<LogGroupField.Builder> getLogGroupFields() {
            return this.logGroupFields != null ? (Collection)this.logGroupFields.stream().map(LogGroupField::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder logGroupFields(Collection<LogGroupField> logGroupFields) {
            this.logGroupFields = LogGroupFieldListCopier.copy(logGroupFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupFields(LogGroupField ... logGroupFields) {
            this.logGroupFields(Arrays.asList(logGroupFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupFields(Consumer<LogGroupField.Builder> ... logGroupFields) {
            this.logGroupFields(Stream.of(logGroupFields).map(c -> (LogGroupField)((LogGroupField.Builder)LogGroupField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLogGroupFields(Collection<LogGroupField.BuilderImpl> logGroupFields) {
            this.logGroupFields = LogGroupFieldListCopier.copyFromBuilder(logGroupFields);
        }

        @Override
        public GetLogGroupFieldsResponse build() {
            return new GetLogGroupFieldsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLogGroupFieldsResponse> {
        public Builder logGroupFields(Collection<LogGroupField> var1);

        public Builder logGroupFields(LogGroupField ... var1);

        public Builder logGroupFields(Consumer<LogGroupField.Builder> ... var1);
    }
}

