/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTaskExecutionInfo;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportTask> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportTask.getter(ExportTask::taskId)).setter(ExportTask.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> TASK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportTask.getter(ExportTask::taskName)).setter(ExportTask.setter(Builder::taskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskName").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportTask.getter(ExportTask::logGroupName)).setter(ExportTask.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<Long> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ExportTask.getter(ExportTask::from)).setter(ExportTask.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()}).build();
    private static final SdkField<Long> TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ExportTask.getter(ExportTask::to)).setter(ExportTask.setter(Builder::to)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("to").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportTask.getter(ExportTask::destination)).setter(ExportTask.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> DESTINATION_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExportTask.getter(ExportTask::destinationPrefix)).setter(ExportTask.setter(Builder::destinationPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPrefix").build()}).build();
    private static final SdkField<ExportTaskStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ExportTask.getter(ExportTask::status)).setter(ExportTask.setter(Builder::status)).constructor(ExportTaskStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ExportTaskExecutionInfo> EXECUTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ExportTask.getter(ExportTask::executionInfo)).setter(ExportTask.setter(Builder::executionInfo)).constructor(ExportTaskExecutionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TASK_NAME_FIELD, LOG_GROUP_NAME_FIELD, FROM_FIELD, TO_FIELD, DESTINATION_FIELD, DESTINATION_PREFIX_FIELD, STATUS_FIELD, EXECUTION_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String taskName;
    private final String logGroupName;
    private final Long from;
    private final Long to;
    private final String destination;
    private final String destinationPrefix;
    private final ExportTaskStatus status;
    private final ExportTaskExecutionInfo executionInfo;

    private ExportTask(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.taskName = builder.taskName;
        this.logGroupName = builder.logGroupName;
        this.from = builder.from;
        this.to = builder.to;
        this.destination = builder.destination;
        this.destinationPrefix = builder.destinationPrefix;
        this.status = builder.status;
        this.executionInfo = builder.executionInfo;
    }

    public String taskId() {
        return this.taskId;
    }

    public String taskName() {
        return this.taskName;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public Long from() {
        return this.from;
    }

    public Long to() {
        return this.to;
    }

    public String destination() {
        return this.destination;
    }

    public String destinationPrefix() {
        return this.destinationPrefix;
    }

    public ExportTaskStatus status() {
        return this.status;
    }

    public ExportTaskExecutionInfo executionInfo() {
        return this.executionInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.to());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTask)) {
            return false;
        }
        ExportTask other = (ExportTask)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.taskName(), other.taskName()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.from(), other.from()) && Objects.equals(this.to(), other.to()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationPrefix(), other.destinationPrefix()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.executionInfo(), other.executionInfo());
    }

    public String toString() {
        return ToString.builder((String)"ExportTask").add("TaskId", (Object)this.taskId()).add("TaskName", (Object)this.taskName()).add("LogGroupName", (Object)this.logGroupName()).add("From", (Object)this.from()).add("To", (Object)this.to()).add("Destination", (Object)this.destination()).add("DestinationPrefix", (Object)this.destinationPrefix()).add("Status", (Object)this.status()).add("ExecutionInfo", (Object)this.executionInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "taskName": {
                return Optional.ofNullable(clazz.cast(this.taskName()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "from": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
            case "to": {
                return Optional.ofNullable(clazz.cast(this.to()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "destinationPrefix": {
                return Optional.ofNullable(clazz.cast(this.destinationPrefix()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "executionInfo": {
                return Optional.ofNullable(clazz.cast(this.executionInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportTask, T> g) {
        return obj -> g.apply((ExportTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String taskName;
        private String logGroupName;
        private Long from;
        private Long to;
        private String destination;
        private String destinationPrefix;
        private ExportTaskStatus status;
        private ExportTaskExecutionInfo executionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTask model) {
            this.taskId(model.taskId);
            this.taskName(model.taskName);
            this.logGroupName(model.logGroupName);
            this.from(model.from);
            this.to(model.to);
            this.destination(model.destination);
            this.destinationPrefix(model.destinationPrefix);
            this.status(model.status);
            this.executionInfo(model.executionInfo);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getTaskName() {
            return this.taskName;
        }

        @Override
        public final Builder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public final void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Long getFrom() {
            return this.from;
        }

        @Override
        public final Builder from(Long from) {
            this.from = from;
            return this;
        }

        public final void setFrom(Long from) {
            this.from = from;
        }

        public final Long getTo() {
            return this.to;
        }

        @Override
        public final Builder to(Long to) {
            this.to = to;
            return this;
        }

        public final void setTo(Long to) {
            this.to = to;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getDestinationPrefix() {
            return this.destinationPrefix;
        }

        @Override
        public final Builder destinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
            return this;
        }

        public final void setDestinationPrefix(String destinationPrefix) {
            this.destinationPrefix = destinationPrefix;
        }

        public final ExportTaskStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(ExportTaskStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ExportTaskStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final ExportTaskExecutionInfo.Builder getExecutionInfo() {
            return this.executionInfo != null ? this.executionInfo.toBuilder() : null;
        }

        @Override
        public final Builder executionInfo(ExportTaskExecutionInfo executionInfo) {
            this.executionInfo = executionInfo;
            return this;
        }

        public final void setExecutionInfo(ExportTaskExecutionInfo.BuilderImpl executionInfo) {
            this.executionInfo = executionInfo != null ? executionInfo.build() : null;
        }

        public ExportTask build() {
            return new ExportTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportTask> {
        public Builder taskId(String var1);

        public Builder taskName(String var1);

        public Builder logGroupName(String var1);

        public Builder from(Long var1);

        public Builder to(Long var1);

        public Builder destination(String var1);

        public Builder destinationPrefix(String var1);

        public Builder status(ExportTaskStatus var1);

        default public Builder status(Consumer<ExportTaskStatus.Builder> status) {
            return this.status((ExportTaskStatus)((ExportTaskStatus.Builder)ExportTaskStatus.builder().applyMutation(status)).build());
        }

        public Builder executionInfo(ExportTaskExecutionInfo var1);

        default public Builder executionInfo(Consumer<ExportTaskExecutionInfo.Builder> executionInfo) {
            return this.executionInfo((ExportTaskExecutionInfo)((ExportTaskExecutionInfo.Builder)ExportTaskExecutionInfo.builder().applyMutation(executionInfo)).build());
        }
    }
}

