/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEvent;

public class GetLogEventsPublisher
implements SdkPublisher<GetLogEventsResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final GetLogEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetLogEventsPublisher(CloudWatchLogsAsyncClient client, GetLogEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetLogEventsPublisher(CloudWatchLogsAsyncClient client, GetLogEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetLogEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetLogEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OutputLogEvent> events() {
        Function<GetLogEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetLogEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final GetLogEventsPublisher resume(GetLogEventsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetLogEventsPublisher(this.client, (GetLogEventsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextForwardToken()).build()));
        }
        return new GetLogEventsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetLogEventsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetLogEventsResponseFetcher
    implements AsyncPageFetcher<GetLogEventsResponse> {
        private GetLogEventsResponseFetcher() {
        }

        public boolean hasNextPage(GetLogEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextForwardToken());
        }

        public CompletableFuture<GetLogEventsResponse> nextPage(GetLogEventsResponse previousPage) {
            if (previousPage == null) {
                return GetLogEventsPublisher.this.client.getLogEvents(GetLogEventsPublisher.this.firstRequest);
            }
            return GetLogEventsPublisher.this.client.getLogEvents((GetLogEventsRequest)((Object)GetLogEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextForwardToken()).build()));
        }
    }
}

