/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagLogGroupRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UntagLogGroupRequestModelMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final UntagLogGroupRequestModelMarshaller INSTANCE = new UntagLogGroupRequestModelMarshaller();

    private UntagLogGroupRequestModelMarshaller() {
    }

    public static UntagLogGroupRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UntagLogGroupRequest untagLogGroupRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)untagLogGroupRequest), (String)"untagLogGroupRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)untagLogGroupRequest.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall(untagLogGroupRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

