/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestMetricFilterRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TestMetricFilterRequestModelMarshaller {
    private static final MarshallingInfo<String> FILTERPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filterPattern").isBinary(false).build();
    private static final MarshallingInfo<List> LOGEVENTMESSAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logEventMessages").isBinary(false).build();
    private static final TestMetricFilterRequestModelMarshaller INSTANCE = new TestMetricFilterRequestModelMarshaller();

    private TestMetricFilterRequestModelMarshaller() {
    }

    public static TestMetricFilterRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TestMetricFilterRequest testMetricFilterRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)testMetricFilterRequest), (String)"testMetricFilterRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)testMetricFilterRequest.filterPattern(), FILTERPATTERN_BINDING);
            protocolMarshaller.marshall(testMetricFilterRequest.logEventMessages(), LOGEVENTMESSAGES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

