/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.SubscriptionFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SubscriptionFilterMarshaller {
    private static final MarshallingInfo<String> FILTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filterName").isBinary(false).build();
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").isBinary(false).build();
    private static final MarshallingInfo<String> FILTERPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filterPattern").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationArn").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> DISTRIBUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("distribution").isBinary(false).build();
    private static final MarshallingInfo<Long> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").isBinary(false).build();
    private static final SubscriptionFilterMarshaller INSTANCE = new SubscriptionFilterMarshaller();

    private SubscriptionFilterMarshaller() {
    }

    public static SubscriptionFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SubscriptionFilter subscriptionFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)subscriptionFilter, (String)"subscriptionFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)subscriptionFilter.filterName(), FILTERNAME_BINDING);
            protocolMarshaller.marshall((Object)subscriptionFilter.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)subscriptionFilter.filterPattern(), FILTERPATTERN_BINDING);
            protocolMarshaller.marshall((Object)subscriptionFilter.destinationArn(), DESTINATIONARN_BINDING);
            protocolMarshaller.marshall((Object)subscriptionFilter.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)subscriptionFilter.distributionAsString(), DISTRIBUTION_BINDING);
            protocolMarshaller.marshall((Object)subscriptionFilter.creationTime(), CREATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

