/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStream;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LogStreamMarshaller {
    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamName").isBinary(false).build();
    private static final MarshallingInfo<Long> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").isBinary(false).build();
    private static final MarshallingInfo<Long> FIRSTEVENTTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstEventTimestamp").isBinary(false).build();
    private static final MarshallingInfo<Long> LASTEVENTTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastEventTimestamp").isBinary(false).build();
    private static final MarshallingInfo<Long> LASTINGESTIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastIngestionTime").isBinary(false).build();
    private static final MarshallingInfo<String> UPLOADSEQUENCETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uploadSequenceToken").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<Long> STOREDBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("storedBytes").isBinary(false).build();
    private static final LogStreamMarshaller INSTANCE = new LogStreamMarshaller();

    private LogStreamMarshaller() {
    }

    public static LogStreamMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LogStream logStream, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)logStream, (String)"logStream");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)logStream.logStreamName(), LOGSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)logStream.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)logStream.firstEventTimestamp(), FIRSTEVENTTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)logStream.lastEventTimestamp(), LASTEVENTTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)logStream.lastIngestionTime(), LASTINGESTIONTIME_BINDING);
            protocolMarshaller.marshall((Object)logStream.uploadSequenceToken(), UPLOADSEQUENCETOKEN_BINDING);
            protocolMarshaller.marshall((Object)logStream.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)logStream.storedBytes(), STOREDBYTES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

