/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LogGroupMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").isBinary(false).build();
    private static final MarshallingInfo<Long> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").isBinary(false).build();
    private static final MarshallingInfo<Integer> RETENTIONINDAYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retentionInDays").isBinary(false).build();
    private static final MarshallingInfo<Integer> METRICFILTERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricFilterCount").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<Long> STOREDBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("storedBytes").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyId").isBinary(false).build();
    private static final LogGroupMarshaller INSTANCE = new LogGroupMarshaller();

    private LogGroupMarshaller() {
    }

    public static LogGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LogGroup logGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)logGroup, (String)"logGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)logGroup.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)logGroup.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)logGroup.retentionInDays(), RETENTIONINDAYS_BINDING);
            protocolMarshaller.marshall((Object)logGroup.metricFilterCount(), METRICFILTERCOUNT_BINDING);
            protocolMarshaller.marshall((Object)logGroup.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)logGroup.storedBytes(), STOREDBYTES_BINDING);
            protocolMarshaller.marshall((Object)logGroup.kmsKeyId(), KMSKEYID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

