/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTaskStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExportTaskStatusMarshaller {
    private static final MarshallingInfo<String> CODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("code").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").isBinary(false).build();
    private static final ExportTaskStatusMarshaller INSTANCE = new ExportTaskStatusMarshaller();

    private ExportTaskStatusMarshaller() {
    }

    public static ExportTaskStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExportTaskStatus exportTaskStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)exportTaskStatus, (String)"exportTaskStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)exportTaskStatus.codeAsString(), CODE_BINDING);
            protocolMarshaller.marshall((Object)exportTaskStatus.message(), MESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

