/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTask;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExportTaskMarshaller {
    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskId").isBinary(false).build();
    private static final MarshallingInfo<String> TASKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskName").isBinary(false).build();
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupName").isBinary(false).build();
    private static final MarshallingInfo<Long> FROM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("from").isBinary(false).build();
    private static final MarshallingInfo<Long> TO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("to").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationPrefix").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionInfo").isBinary(false).build();
    private static final ExportTaskMarshaller INSTANCE = new ExportTaskMarshaller();

    private ExportTaskMarshaller() {
    }

    public static ExportTaskMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExportTask exportTask, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)exportTask, (String)"exportTask");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)exportTask.taskId(), TASKID_BINDING);
            protocolMarshaller.marshall((Object)exportTask.taskName(), TASKNAME_BINDING);
            protocolMarshaller.marshall((Object)exportTask.logGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)exportTask.from(), FROM_BINDING);
            protocolMarshaller.marshall((Object)exportTask.to(), TO_BINDING);
            protocolMarshaller.marshall((Object)exportTask.destination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)exportTask.destinationPrefix(), DESTINATIONPREFIX_BINDING);
            protocolMarshaller.marshall((Object)exportTask.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)exportTask.executionInfo(), EXECUTIONINFO_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

