/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.Destination;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DestinationMarshaller {
    private static final MarshallingInfo<String> DESTINATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationName").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetArn").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> ACCESSPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessPolicy").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<Long> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").isBinary(false).build();
    private static final DestinationMarshaller INSTANCE = new DestinationMarshaller();

    private DestinationMarshaller() {
    }

    public static DestinationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Destination destination, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)destination, (String)"destination");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)destination.destinationName(), DESTINATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)destination.targetArn(), TARGETARN_BINDING);
            protocolMarshaller.marshall((Object)destination.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)destination.accessPolicy(), ACCESSPOLICY_BINDING);
            protocolMarshaller.marshall((Object)destination.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)destination.creationTime(), CREATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

