/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeLogGroupsRequestModelMarshaller {
    private static final MarshallingInfo<String> LOGGROUPNAMEPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logGroupNamePrefix").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("limit").isBinary(false).build();
    private static final DescribeLogGroupsRequestModelMarshaller INSTANCE = new DescribeLogGroupsRequestModelMarshaller();

    private DescribeLogGroupsRequestModelMarshaller() {
    }

    public static DescribeLogGroupsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeLogGroupsRequest describeLogGroupsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeLogGroupsRequest), (String)"describeLogGroupsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeLogGroupsRequest.logGroupNamePrefix(), LOGGROUPNAMEPREFIX_BINDING);
            protocolMarshaller.marshall((Object)describeLogGroupsRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)describeLogGroupsRequest.limit(), LIMIT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

