/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.RejectedLogEventsInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutLogEventsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, PutLogEventsResponse> {
    private final String nextSequenceToken;
    private final RejectedLogEventsInfo rejectedLogEventsInfo;

    private PutLogEventsResponse(BuilderImpl builder) {
        super(builder);
        this.nextSequenceToken = builder.nextSequenceToken;
        this.rejectedLogEventsInfo = builder.rejectedLogEventsInfo;
    }

    public String nextSequenceToken() {
        return this.nextSequenceToken;
    }

    public RejectedLogEventsInfo rejectedLogEventsInfo() {
        return this.rejectedLogEventsInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextSequenceToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectedLogEventsInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLogEventsResponse)) {
            return false;
        }
        PutLogEventsResponse other = (PutLogEventsResponse)((Object)obj);
        return Objects.equals(this.nextSequenceToken(), other.nextSequenceToken()) && Objects.equals(this.rejectedLogEventsInfo(), other.rejectedLogEventsInfo());
    }

    public String toString() {
        return ToString.builder((String)"PutLogEventsResponse").add("NextSequenceToken", (Object)this.nextSequenceToken()).add("RejectedLogEventsInfo", (Object)this.rejectedLogEventsInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextSequenceToken": {
                return Optional.ofNullable(clazz.cast(this.nextSequenceToken()));
            }
            case "rejectedLogEventsInfo": {
                return Optional.ofNullable(clazz.cast(this.rejectedLogEventsInfo()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private String nextSequenceToken;
        private RejectedLogEventsInfo rejectedLogEventsInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLogEventsResponse model) {
            super(model);
            this.nextSequenceToken(model.nextSequenceToken);
            this.rejectedLogEventsInfo(model.rejectedLogEventsInfo);
        }

        public final String getNextSequenceToken() {
            return this.nextSequenceToken;
        }

        @Override
        public final Builder nextSequenceToken(String nextSequenceToken) {
            this.nextSequenceToken = nextSequenceToken;
            return this;
        }

        public final void setNextSequenceToken(String nextSequenceToken) {
            this.nextSequenceToken = nextSequenceToken;
        }

        public final RejectedLogEventsInfo.Builder getRejectedLogEventsInfo() {
            return this.rejectedLogEventsInfo != null ? this.rejectedLogEventsInfo.toBuilder() : null;
        }

        @Override
        public final Builder rejectedLogEventsInfo(RejectedLogEventsInfo rejectedLogEventsInfo) {
            this.rejectedLogEventsInfo = rejectedLogEventsInfo;
            return this;
        }

        public final void setRejectedLogEventsInfo(RejectedLogEventsInfo.BuilderImpl rejectedLogEventsInfo) {
            this.rejectedLogEventsInfo = rejectedLogEventsInfo != null ? rejectedLogEventsInfo.build() : null;
        }

        @Override
        public PutLogEventsResponse build() {
            return new PutLogEventsResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    CopyableBuilder<Builder, PutLogEventsResponse> {
        public Builder nextSequenceToken(String var1);

        public Builder rejectedLogEventsInfo(RejectedLogEventsInfo var1);

        default public Builder rejectedLogEventsInfo(Consumer<RejectedLogEventsInfo.Builder> rejectedLogEventsInfo) {
            return this.rejectedLogEventsInfo((RejectedLogEventsInfo)((RejectedLogEventsInfo.Builder)RejectedLogEventsInfo.builder().applyMutation(rejectedLogEventsInfo)).build());
        }
    }
}

