/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformation;
import software.amazon.awssdk.services.cloudwatchlogs.model.MetricTransformationsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.transform.MetricFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, MetricFilter> {
    private final String filterName;
    private final String filterPattern;
    private final List<MetricTransformation> metricTransformations;
    private final Long creationTime;
    private final String logGroupName;

    private MetricFilter(BuilderImpl builder) {
        this.filterName = builder.filterName;
        this.filterPattern = builder.filterPattern;
        this.metricTransformations = builder.metricTransformations;
        this.creationTime = builder.creationTime;
        this.logGroupName = builder.logGroupName;
    }

    public String filterName() {
        return this.filterName;
    }

    public String filterPattern() {
        return this.filterPattern;
    }

    public List<MetricTransformation> metricTransformations() {
        return this.metricTransformations;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricTransformations());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricFilter)) {
            return false;
        }
        MetricFilter other = (MetricFilter)obj;
        return Objects.equals(this.filterName(), other.filterName()) && Objects.equals(this.filterPattern(), other.filterPattern()) && Objects.equals(this.metricTransformations(), other.metricTransformations()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.logGroupName(), other.logGroupName());
    }

    public String toString() {
        return ToString.builder((String)"MetricFilter").add("FilterName", (Object)this.filterName()).add("FilterPattern", (Object)this.filterPattern()).add("MetricTransformations", this.metricTransformations()).add("CreationTime", (Object)this.creationTime()).add("LogGroupName", (Object)this.logGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterName": {
                return Optional.ofNullable(clazz.cast(this.filterName()));
            }
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "metricTransformations": {
                return Optional.ofNullable(clazz.cast(this.metricTransformations()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterName;
        private String filterPattern;
        private List<MetricTransformation> metricTransformations = DefaultSdkAutoConstructList.getInstance();
        private Long creationTime;
        private String logGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricFilter model) {
            this.filterName(model.filterName);
            this.filterPattern(model.filterPattern);
            this.metricTransformations(model.metricTransformations);
            this.creationTime(model.creationTime);
            this.logGroupName(model.logGroupName);
        }

        public final String getFilterName() {
            return this.filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final Collection<MetricTransformation.Builder> getMetricTransformations() {
            return this.metricTransformations != null ? (Collection)this.metricTransformations.stream().map(MetricTransformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricTransformations(Collection<MetricTransformation> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copy(metricTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(MetricTransformation ... metricTransformations) {
            this.metricTransformations(Arrays.asList(metricTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(Consumer<MetricTransformation.Builder> ... metricTransformations) {
            this.metricTransformations(Stream.of(metricTransformations).map(c -> (MetricTransformation)((MetricTransformation.Builder)MetricTransformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricTransformations(Collection<MetricTransformation.BuilderImpl> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copyFromBuilder(metricTransformations);
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public MetricFilter build() {
            return new MetricFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricFilter> {
        public Builder filterName(String var1);

        public Builder filterPattern(String var1);

        public Builder metricTransformations(Collection<MetricTransformation> var1);

        public Builder metricTransformations(MetricTransformation ... var1);

        public Builder metricTransformations(Consumer<MetricTransformation.Builder> ... var1);

        public Builder creationTime(Long var1);

        public Builder logGroupName(String var1);
    }
}

