/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLogEventsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, GetLogEventsResponse> {
    private final List<OutputLogEvent> events;
    private final String nextForwardToken;
    private final String nextBackwardToken;

    private GetLogEventsResponse(BuilderImpl builder) {
        super(builder);
        this.events = builder.events;
        this.nextForwardToken = builder.nextForwardToken;
        this.nextBackwardToken = builder.nextBackwardToken;
    }

    public List<OutputLogEvent> events() {
        return this.events;
    }

    public String nextForwardToken() {
        return this.nextForwardToken;
    }

    public String nextBackwardToken() {
        return this.nextBackwardToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextForwardToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextBackwardToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogEventsResponse)) {
            return false;
        }
        GetLogEventsResponse other = (GetLogEventsResponse)((Object)obj);
        return Objects.equals(this.events(), other.events()) && Objects.equals(this.nextForwardToken(), other.nextForwardToken()) && Objects.equals(this.nextBackwardToken(), other.nextBackwardToken());
    }

    public String toString() {
        return ToString.builder((String)"GetLogEventsResponse").add("Events", this.events()).add("NextForwardToken", (Object)this.nextForwardToken()).add("NextBackwardToken", (Object)this.nextBackwardToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "nextForwardToken": {
                return Optional.ofNullable(clazz.cast(this.nextForwardToken()));
            }
            case "nextBackwardToken": {
                return Optional.ofNullable(clazz.cast(this.nextBackwardToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<OutputLogEvent> events = DefaultSdkAutoConstructList.getInstance();
        private String nextForwardToken;
        private String nextBackwardToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogEventsResponse model) {
            super(model);
            this.events(model.events);
            this.nextForwardToken(model.nextForwardToken);
            this.nextBackwardToken(model.nextBackwardToken);
        }

        public final Collection<OutputLogEvent.Builder> getEvents() {
            return this.events != null ? (Collection)this.events.stream().map(OutputLogEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<OutputLogEvent> events) {
            this.events = OutputLogEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(OutputLogEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<OutputLogEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (OutputLogEvent)((OutputLogEvent.Builder)OutputLogEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<OutputLogEvent.BuilderImpl> events) {
            this.events = OutputLogEventsCopier.copyFromBuilder(events);
        }

        public final String getNextForwardToken() {
            return this.nextForwardToken;
        }

        @Override
        public final Builder nextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
            return this;
        }

        public final void setNextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
        }

        public final String getNextBackwardToken() {
            return this.nextBackwardToken;
        }

        @Override
        public final Builder nextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
            return this;
        }

        public final void setNextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
        }

        @Override
        public GetLogEventsResponse build() {
            return new GetLogEventsResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    CopyableBuilder<Builder, GetLogEventsResponse> {
        public Builder events(Collection<OutputLogEvent> var1);

        public Builder events(OutputLogEvent ... var1);

        public Builder events(Consumer<OutputLogEvent.Builder> ... var1);

        public Builder nextForwardToken(String var1);

        public Builder nextBackwardToken(String var1);
    }
}

