/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ExportTaskExecutionInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportTaskExecutionInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, ExportTaskExecutionInfo> {
    private final Long creationTime;
    private final Long completionTime;

    private ExportTaskExecutionInfo(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
    }

    public Long creationTime() {
        return this.creationTime;
    }

    public Long completionTime() {
        return this.completionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTaskExecutionInfo)) {
            return false;
        }
        ExportTaskExecutionInfo other = (ExportTaskExecutionInfo)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.completionTime(), other.completionTime());
    }

    public String toString() {
        return ToString.builder((String)"ExportTaskExecutionInfo").add("CreationTime", (Object)this.creationTime()).add("CompletionTime", (Object)this.completionTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "completionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExportTaskExecutionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long creationTime;
        private Long completionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTaskExecutionInfo model) {
            this.creationTime(model.creationTime);
            this.completionTime(model.completionTime);
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final Long getCompletionTime() {
            return this.completionTime;
        }

        @Override
        public final Builder completionTime(Long completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final void setCompletionTime(Long completionTime) {
            this.completionTime = completionTime;
        }

        public ExportTaskExecutionInfo build() {
            return new ExportTaskExecutionInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExportTaskExecutionInfo> {
        public Builder creationTime(Long var1);

        public Builder completionTime(Long var1);
    }
}

