/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.SubscriptionFilter;
import software.amazon.awssdk.services.cloudwatchlogs.model.SubscriptionFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSubscriptionFiltersResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeSubscriptionFiltersResponse> {
    private final List<SubscriptionFilter> subscriptionFilters;
    private final String nextToken;

    private DescribeSubscriptionFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.subscriptionFilters = builder.subscriptionFilters;
        this.nextToken = builder.nextToken;
    }

    public List<SubscriptionFilter> subscriptionFilters() {
        return this.subscriptionFilters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubscriptionFiltersResponse)) {
            return false;
        }
        DescribeSubscriptionFiltersResponse other = (DescribeSubscriptionFiltersResponse)((Object)obj);
        return Objects.equals(this.subscriptionFilters(), other.subscriptionFilters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSubscriptionFiltersResponse").add("SubscriptionFilters", this.subscriptionFilters()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "subscriptionFilters": {
                return Optional.ofNullable(clazz.cast(this.subscriptionFilters()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<SubscriptionFilter> subscriptionFilters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubscriptionFiltersResponse model) {
            super(model);
            this.subscriptionFilters(model.subscriptionFilters);
            this.nextToken(model.nextToken);
        }

        public final Collection<SubscriptionFilter.Builder> getSubscriptionFilters() {
            return this.subscriptionFilters != null ? (Collection)this.subscriptionFilters.stream().map(SubscriptionFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscriptionFilters(Collection<SubscriptionFilter> subscriptionFilters) {
            this.subscriptionFilters = SubscriptionFiltersCopier.copy(subscriptionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionFilters(SubscriptionFilter ... subscriptionFilters) {
            this.subscriptionFilters(Arrays.asList(subscriptionFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionFilters(Consumer<SubscriptionFilter.Builder> ... subscriptionFilters) {
            this.subscriptionFilters(Stream.of(subscriptionFilters).map(c -> (SubscriptionFilter)((SubscriptionFilter.Builder)SubscriptionFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscriptionFilters(Collection<SubscriptionFilter.BuilderImpl> subscriptionFilters) {
            this.subscriptionFilters = SubscriptionFiltersCopier.copyFromBuilder(subscriptionFilters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSubscriptionFiltersResponse build() {
            return new DescribeSubscriptionFiltersResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    CopyableBuilder<Builder, DescribeSubscriptionFiltersResponse> {
        public Builder subscriptionFilters(Collection<SubscriptionFilter> var1);

        public Builder subscriptionFilters(SubscriptionFilter ... var1);

        public Builder subscriptionFilters(Consumer<SubscriptionFilter.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

