/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMetricFiltersRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, DescribeMetricFiltersRequest> {
    private final String logGroupName;
    private final String filterNamePrefix;
    private final String nextToken;
    private final Integer limit;
    private final String metricName;
    private final String metricNamespace;

    private DescribeMetricFiltersRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.filterNamePrefix = builder.filterNamePrefix;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.metricName = builder.metricName;
        this.metricNamespace = builder.metricNamespace;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String filterNamePrefix() {
        return this.filterNamePrefix;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    public String metricName() {
        return this.metricName;
    }

    public String metricNamespace() {
        return this.metricNamespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNamespace());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricFiltersRequest)) {
            return false;
        }
        DescribeMetricFiltersRequest other = (DescribeMetricFiltersRequest)((Object)obj);
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.filterNamePrefix(), other.filterNamePrefix()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.metricNamespace(), other.metricNamespace());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMetricFiltersRequest").add("LogGroupName", (Object)this.logGroupName()).add("FilterNamePrefix", (Object)this.filterNamePrefix()).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).add("MetricName", (Object)this.metricName()).add("MetricNamespace", (Object)this.metricNamespace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "filterNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.filterNamePrefix()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "metricNamespace": {
                return Optional.ofNullable(clazz.cast(this.metricNamespace()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupName;
        private String filterNamePrefix;
        private String nextToken;
        private Integer limit;
        private String metricName;
        private String metricNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricFiltersRequest model) {
            super(model);
            this.logGroupName(model.logGroupName);
            this.filterNamePrefix(model.filterNamePrefix);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
            this.metricName(model.metricName);
            this.metricNamespace(model.metricNamespace);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getFilterNamePrefix() {
            return this.filterNamePrefix;
        }

        @Override
        public final Builder filterNamePrefix(String filterNamePrefix) {
            this.filterNamePrefix = filterNamePrefix;
            return this;
        }

        public final void setFilterNamePrefix(String filterNamePrefix) {
            this.filterNamePrefix = filterNamePrefix;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMetricNamespace() {
            return this.metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMetricFiltersRequest build() {
            return new DescribeMetricFiltersRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    CopyableBuilder<Builder, DescribeMetricFiltersRequest> {
        public Builder logGroupName(String var1);

        public Builder filterNamePrefix(String var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder metricName(String var1);

        public Builder metricNamespace(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

