/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStream;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStreamsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLogStreamsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeLogStreamsResponse> {
    private final List<LogStream> logStreams;
    private final String nextToken;

    private DescribeLogStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.logStreams = builder.logStreams;
        this.nextToken = builder.nextToken;
    }

    public List<LogStream> logStreams() {
        return this.logStreams;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreams());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogStreamsResponse)) {
            return false;
        }
        DescribeLogStreamsResponse other = (DescribeLogStreamsResponse)((Object)obj);
        return Objects.equals(this.logStreams(), other.logStreams()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLogStreamsResponse").add("LogStreams", this.logStreams()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logStreams": {
                return Optional.ofNullable(clazz.cast(this.logStreams()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<LogStream> logStreams = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogStreamsResponse model) {
            super(model);
            this.logStreams(model.logStreams);
            this.nextToken(model.nextToken);
        }

        public final Collection<LogStream.Builder> getLogStreams() {
            return this.logStreams != null ? (Collection)this.logStreams.stream().map(LogStream::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder logStreams(Collection<LogStream> logStreams) {
            this.logStreams = LogStreamsCopier.copy(logStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreams(LogStream ... logStreams) {
            this.logStreams(Arrays.asList(logStreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreams(Consumer<LogStream.Builder> ... logStreams) {
            this.logStreams(Stream.of(logStreams).map(c -> (LogStream)((LogStream.Builder)LogStream.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLogStreams(Collection<LogStream.BuilderImpl> logStreams) {
            this.logStreams = LogStreamsCopier.copyFromBuilder(logStreams);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLogStreamsResponse build() {
            return new DescribeLogStreamsResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    CopyableBuilder<Builder, DescribeLogStreamsResponse> {
        public Builder logStreams(Collection<LogStream> var1);

        public Builder logStreams(LogStream ... var1);

        public Builder logStreams(Consumer<LogStream.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

