/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.OrderBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLogStreamsRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, DescribeLogStreamsRequest> {
    private final String logGroupName;
    private final String logStreamNamePrefix;
    private final String orderBy;
    private final Boolean descending;
    private final String nextToken;
    private final Integer limit;

    private DescribeLogStreamsRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
        this.orderBy = builder.orderBy;
        this.descending = builder.descending;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String logStreamNamePrefix() {
        return this.logStreamNamePrefix;
    }

    public OrderBy orderBy() {
        return OrderBy.fromValue(this.orderBy);
    }

    public String orderByAsString() {
        return this.orderBy;
    }

    public Boolean descending() {
        return this.descending;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.descending());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogStreamsRequest)) {
            return false;
        }
        DescribeLogStreamsRequest other = (DescribeLogStreamsRequest)((Object)obj);
        return Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.logStreamNamePrefix(), other.logStreamNamePrefix()) && Objects.equals(this.orderByAsString(), other.orderByAsString()) && Objects.equals(this.descending(), other.descending()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLogStreamsRequest").add("LogGroupName", (Object)this.logGroupName()).add("LogStreamNamePrefix", (Object)this.logStreamNamePrefix()).add("OrderBy", (Object)this.orderByAsString()).add("Descending", (Object)this.descending()).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "logStreamNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.logStreamNamePrefix()));
            }
            case "orderBy": {
                return Optional.ofNullable(clazz.cast(this.orderByAsString()));
            }
            case "descending": {
                return Optional.ofNullable(clazz.cast(this.descending()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupName;
        private String logStreamNamePrefix;
        private String orderBy;
        private Boolean descending;
        private String nextToken;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogStreamsRequest model) {
            super(model);
            this.logGroupName(model.logGroupName);
            this.logStreamNamePrefix(model.logStreamNamePrefix);
            this.orderBy(model.orderBy);
            this.descending(model.descending);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamNamePrefix() {
            return this.logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        public final String getOrderBy() {
            return this.orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy(orderBy.toString());
            return this;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public final Boolean getDescending() {
            return this.descending;
        }

        @Override
        public final Builder descending(Boolean descending) {
            this.descending = descending;
            return this;
        }

        public final void setDescending(Boolean descending) {
            this.descending = descending;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLogStreamsRequest build() {
            return new DescribeLogStreamsRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    CopyableBuilder<Builder, DescribeLogStreamsRequest> {
        public Builder logGroupName(String var1);

        public Builder logStreamNamePrefix(String var1);

        public Builder orderBy(String var1);

        public Builder orderBy(OrderBy var1);

        public Builder descending(Boolean var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

