/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTask;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExportTasksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExportTasksResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeExportTasksResponse> {
    private final List<ExportTask> exportTasks;
    private final String nextToken;

    private DescribeExportTasksResponse(BuilderImpl builder) {
        super(builder);
        this.exportTasks = builder.exportTasks;
        this.nextToken = builder.nextToken;
    }

    public List<ExportTask> exportTasks() {
        return this.exportTasks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksResponse)) {
            return false;
        }
        DescribeExportTasksResponse other = (DescribeExportTasksResponse)((Object)obj);
        return Objects.equals(this.exportTasks(), other.exportTasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeExportTasksResponse").add("ExportTasks", this.exportTasks()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportTasks": {
                return Optional.ofNullable(clazz.cast(this.exportTasks()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<ExportTask> exportTasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksResponse model) {
            super(model);
            this.exportTasks(model.exportTasks);
            this.nextToken(model.nextToken);
        }

        public final Collection<ExportTask.Builder> getExportTasks() {
            return this.exportTasks != null ? (Collection)this.exportTasks.stream().map(ExportTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder exportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTasksCopier.copy(exportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(ExportTask ... exportTasks) {
            this.exportTasks(Arrays.asList(exportTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(Consumer<ExportTask.Builder> ... exportTasks) {
            this.exportTasks(Stream.of(exportTasks).map(c -> (ExportTask)((ExportTask.Builder)ExportTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExportTasks(Collection<ExportTask.BuilderImpl> exportTasks) {
            this.exportTasks = ExportTasksCopier.copyFromBuilder(exportTasks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeExportTasksResponse build() {
            return new DescribeExportTasksResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    CopyableBuilder<Builder, DescribeExportTasksResponse> {
        public Builder exportTasks(Collection<ExportTask> var1);

        public Builder exportTasks(ExportTask ... var1);

        public Builder exportTasks(Consumer<ExportTask.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

