/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.Destination;
import software.amazon.awssdk.services.cloudwatchlogs.model.DestinationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDestinationsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeDestinationsResponse> {
    private final List<Destination> destinations;
    private final String nextToken;

    private DescribeDestinationsResponse(BuilderImpl builder) {
        super(builder);
        this.destinations = builder.destinations;
        this.nextToken = builder.nextToken;
    }

    public List<Destination> destinations() {
        return this.destinations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDestinationsResponse)) {
            return false;
        }
        DescribeDestinationsResponse other = (DescribeDestinationsResponse)((Object)obj);
        return Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDestinationsResponse").add("Destinations", this.destinations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<Destination> destinations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDestinationsResponse model) {
            super(model);
            this.destinations(model.destinations);
            this.nextToken(model.nextToken);
        }

        public final Collection<Destination.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(Destination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<Destination> destinations) {
            this.destinations = DestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Destination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<Destination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (Destination)((Destination.Builder)Destination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<Destination.BuilderImpl> destinations) {
            this.destinations = DestinationsCopier.copyFromBuilder(destinations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDestinationsResponse build() {
            return new DescribeDestinationsResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    CopyableBuilder<Builder, DescribeDestinationsResponse> {
        public Builder destinations(Collection<Destination> var1);

        public Builder destinations(Destination ... var1);

        public Builder destinations(Consumer<Destination.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

