/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.ReplayState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Replay
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Replay> {
    private static final SdkField<String> REPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplayName").getter(Replay.getter(Replay::replayName)).setter(Replay.setter(Builder::replayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayName").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSourceArn").getter(Replay.getter(Replay::eventSourceArn)).setter(Replay.setter(Builder::eventSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Replay.getter(Replay::stateAsString)).setter(Replay.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(Replay.getter(Replay::stateReason)).setter(Replay.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<Instant> EVENT_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventStartTime").getter(Replay.getter(Replay::eventStartTime)).setter(Replay.setter(Builder::eventStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStartTime").build()}).build();
    private static final SdkField<Instant> EVENT_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventEndTime").getter(Replay.getter(Replay::eventEndTime)).setter(Replay.setter(Builder::eventEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventEndTime").build()}).build();
    private static final SdkField<Instant> EVENT_LAST_REPLAYED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventLastReplayedTime").getter(Replay.getter(Replay::eventLastReplayedTime)).setter(Replay.setter(Builder::eventLastReplayedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventLastReplayedTime").build()}).build();
    private static final SdkField<Instant> REPLAY_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplayStartTime").getter(Replay.getter(Replay::replayStartTime)).setter(Replay.setter(Builder::replayStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayStartTime").build()}).build();
    private static final SdkField<Instant> REPLAY_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplayEndTime").getter(Replay.getter(Replay::replayEndTime)).setter(Replay.setter(Builder::replayEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLAY_NAME_FIELD, EVENT_SOURCE_ARN_FIELD, STATE_FIELD, STATE_REASON_FIELD, EVENT_START_TIME_FIELD, EVENT_END_TIME_FIELD, EVENT_LAST_REPLAYED_TIME_FIELD, REPLAY_START_TIME_FIELD, REPLAY_END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Replay.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String replayName;
    private final String eventSourceArn;
    private final String state;
    private final String stateReason;
    private final Instant eventStartTime;
    private final Instant eventEndTime;
    private final Instant eventLastReplayedTime;
    private final Instant replayStartTime;
    private final Instant replayEndTime;

    private Replay(BuilderImpl builder) {
        this.replayName = builder.replayName;
        this.eventSourceArn = builder.eventSourceArn;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.eventStartTime = builder.eventStartTime;
        this.eventEndTime = builder.eventEndTime;
        this.eventLastReplayedTime = builder.eventLastReplayedTime;
        this.replayStartTime = builder.replayStartTime;
        this.replayEndTime = builder.replayEndTime;
    }

    public final String replayName() {
        return this.replayName;
    }

    public final String eventSourceArn() {
        return this.eventSourceArn;
    }

    public final ReplayState state() {
        return ReplayState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final Instant eventStartTime() {
        return this.eventStartTime;
    }

    public final Instant eventEndTime() {
        return this.eventEndTime;
    }

    public final Instant eventLastReplayedTime() {
        return this.eventLastReplayedTime;
    }

    public final Instant replayStartTime() {
        return this.replayStartTime;
    }

    public final Instant replayEndTime() {
        return this.replayEndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventLastReplayedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.replayStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.replayEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Replay)) {
            return false;
        }
        Replay other = (Replay)obj;
        return Objects.equals(this.replayName(), other.replayName()) && Objects.equals(this.eventSourceArn(), other.eventSourceArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.eventStartTime(), other.eventStartTime()) && Objects.equals(this.eventEndTime(), other.eventEndTime()) && Objects.equals(this.eventLastReplayedTime(), other.eventLastReplayedTime()) && Objects.equals(this.replayStartTime(), other.replayStartTime()) && Objects.equals(this.replayEndTime(), other.replayEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"Replay").add("ReplayName", (Object)this.replayName()).add("EventSourceArn", (Object)this.eventSourceArn()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("EventStartTime", (Object)this.eventStartTime()).add("EventEndTime", (Object)this.eventEndTime()).add("EventLastReplayedTime", (Object)this.eventLastReplayedTime()).add("ReplayStartTime", (Object)this.replayStartTime()).add("ReplayEndTime", (Object)this.replayEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplayName": {
                return Optional.ofNullable(clazz.cast(this.replayName()));
            }
            case "EventSourceArn": {
                return Optional.ofNullable(clazz.cast(this.eventSourceArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "EventStartTime": {
                return Optional.ofNullable(clazz.cast(this.eventStartTime()));
            }
            case "EventEndTime": {
                return Optional.ofNullable(clazz.cast(this.eventEndTime()));
            }
            case "EventLastReplayedTime": {
                return Optional.ofNullable(clazz.cast(this.eventLastReplayedTime()));
            }
            case "ReplayStartTime": {
                return Optional.ofNullable(clazz.cast(this.replayStartTime()));
            }
            case "ReplayEndTime": {
                return Optional.ofNullable(clazz.cast(this.replayEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReplayName", REPLAY_NAME_FIELD);
        map.put("EventSourceArn", EVENT_SOURCE_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("EventStartTime", EVENT_START_TIME_FIELD);
        map.put("EventEndTime", EVENT_END_TIME_FIELD);
        map.put("EventLastReplayedTime", EVENT_LAST_REPLAYED_TIME_FIELD);
        map.put("ReplayStartTime", REPLAY_START_TIME_FIELD);
        map.put("ReplayEndTime", REPLAY_END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Replay, T> g) {
        return obj -> g.apply((Replay)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replayName;
        private String eventSourceArn;
        private String state;
        private String stateReason;
        private Instant eventStartTime;
        private Instant eventEndTime;
        private Instant eventLastReplayedTime;
        private Instant replayStartTime;
        private Instant replayEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Replay model) {
            this.replayName(model.replayName);
            this.eventSourceArn(model.eventSourceArn);
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.eventStartTime(model.eventStartTime);
            this.eventEndTime(model.eventEndTime);
            this.eventLastReplayedTime(model.eventLastReplayedTime);
            this.replayStartTime(model.replayStartTime);
            this.replayEndTime(model.replayEndTime);
        }

        public final String getReplayName() {
            return this.replayName;
        }

        public final void setReplayName(String replayName) {
            this.replayName = replayName;
        }

        @Override
        public final Builder replayName(String replayName) {
            this.replayName = replayName;
            return this;
        }

        public final String getEventSourceArn() {
            return this.eventSourceArn;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReplayState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final Instant getEventStartTime() {
            return this.eventStartTime;
        }

        public final void setEventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
        }

        @Override
        public final Builder eventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
            return this;
        }

        public final Instant getEventEndTime() {
            return this.eventEndTime;
        }

        public final void setEventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
        }

        @Override
        public final Builder eventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
            return this;
        }

        public final Instant getEventLastReplayedTime() {
            return this.eventLastReplayedTime;
        }

        public final void setEventLastReplayedTime(Instant eventLastReplayedTime) {
            this.eventLastReplayedTime = eventLastReplayedTime;
        }

        @Override
        public final Builder eventLastReplayedTime(Instant eventLastReplayedTime) {
            this.eventLastReplayedTime = eventLastReplayedTime;
            return this;
        }

        public final Instant getReplayStartTime() {
            return this.replayStartTime;
        }

        public final void setReplayStartTime(Instant replayStartTime) {
            this.replayStartTime = replayStartTime;
        }

        @Override
        public final Builder replayStartTime(Instant replayStartTime) {
            this.replayStartTime = replayStartTime;
            return this;
        }

        public final Instant getReplayEndTime() {
            return this.replayEndTime;
        }

        public final void setReplayEndTime(Instant replayEndTime) {
            this.replayEndTime = replayEndTime;
        }

        @Override
        public final Builder replayEndTime(Instant replayEndTime) {
            this.replayEndTime = replayEndTime;
            return this;
        }

        public Replay build() {
            return new Replay(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Replay> {
        public Builder replayName(String var1);

        public Builder eventSourceArn(String var1);

        public Builder state(String var1);

        public Builder state(ReplayState var1);

        public Builder stateReason(String var1);

        public Builder eventStartTime(Instant var1);

        public Builder eventEndTime(Instant var1);

        public Builder eventLastReplayedTime(Instant var1);

        public Builder replayStartTime(Instant var1);

        public Builder replayEndTime(Instant var1);
    }
}

