/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.EventResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventsRequestEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PutEventsRequestEntry> {
    private static final SdkField<Instant> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Time").getter(PutEventsRequestEntry.getter(PutEventsRequestEntry::time)).setter(PutEventsRequestEntry.setter(Builder::time)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(PutEventsRequestEntry.getter(PutEventsRequestEntry::source)).setter(PutEventsRequestEntry.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(PutEventsRequestEntry.getter(PutEventsRequestEntry::resources)).setter(PutEventsRequestEntry.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetailType").getter(PutEventsRequestEntry.getter(PutEventsRequestEntry::detailType)).setter(PutEventsRequestEntry.setter(Builder::detailType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()}).build();
    private static final SdkField<String> DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Detail").getter(PutEventsRequestEntry.getter(PutEventsRequestEntry::detail)).setter(PutEventsRequestEntry.setter(Builder::detail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detail").build()}).build();
    private static final SdkField<String> EVENT_BUS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventBusName").getter(PutEventsRequestEntry.getter(PutEventsRequestEntry::eventBusName)).setter(PutEventsRequestEntry.setter(Builder::eventBusName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusName").build()}).build();
    private static final SdkField<String> TRACE_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TraceHeader").getter(PutEventsRequestEntry.getter(PutEventsRequestEntry::traceHeader)).setter(PutEventsRequestEntry.setter(Builder::traceHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceHeader").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_FIELD, SOURCE_FIELD, RESOURCES_FIELD, DETAIL_TYPE_FIELD, DETAIL_FIELD, EVENT_BUS_NAME_FIELD, TRACE_HEADER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutEventsRequestEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant time;
    private final String source;
    private final List<String> resources;
    private final String detailType;
    private final String detail;
    private final String eventBusName;
    private final String traceHeader;

    private PutEventsRequestEntry(BuilderImpl builder) {
        this.time = builder.time;
        this.source = builder.source;
        this.resources = builder.resources;
        this.detailType = builder.detailType;
        this.detail = builder.detail;
        this.eventBusName = builder.eventBusName;
        this.traceHeader = builder.traceHeader;
    }

    public final Instant time() {
        return this.time;
    }

    public final String source() {
        return this.source;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<String> resources() {
        return this.resources;
    }

    public final String detailType() {
        return this.detailType;
    }

    public final String detail() {
        return this.detail;
    }

    public final String eventBusName() {
        return this.eventBusName;
    }

    public final String traceHeader() {
        return this.traceHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.detailType());
        hashCode = 31 * hashCode + Objects.hashCode(this.detail());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBusName());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceHeader());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsRequestEntry)) {
            return false;
        }
        PutEventsRequestEntry other = (PutEventsRequestEntry)obj;
        return Objects.equals(this.time(), other.time()) && Objects.equals(this.source(), other.source()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.detailType(), other.detailType()) && Objects.equals(this.detail(), other.detail()) && Objects.equals(this.eventBusName(), other.eventBusName()) && Objects.equals(this.traceHeader(), other.traceHeader());
    }

    public final String toString() {
        return ToString.builder((String)"PutEventsRequestEntry").add("Time", (Object)this.time()).add("Source", (Object)this.source()).add("Resources", this.hasResources() ? this.resources() : null).add("DetailType", (Object)this.detailType()).add("Detail", (Object)this.detail()).add("EventBusName", (Object)this.eventBusName()).add("TraceHeader", (Object)this.traceHeader()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "DetailType": {
                return Optional.ofNullable(clazz.cast(this.detailType()));
            }
            case "Detail": {
                return Optional.ofNullable(clazz.cast(this.detail()));
            }
            case "EventBusName": {
                return Optional.ofNullable(clazz.cast(this.eventBusName()));
            }
            case "TraceHeader": {
                return Optional.ofNullable(clazz.cast(this.traceHeader()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Time", TIME_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("Resources", RESOURCES_FIELD);
        map.put("DetailType", DETAIL_TYPE_FIELD);
        map.put("Detail", DETAIL_FIELD);
        map.put("EventBusName", EVENT_BUS_NAME_FIELD);
        map.put("TraceHeader", TRACE_HEADER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutEventsRequestEntry, T> g) {
        return obj -> g.apply((PutEventsRequestEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant time;
        private String source;
        private List<String> resources = DefaultSdkAutoConstructList.getInstance();
        private String detailType;
        private String detail;
        private String eventBusName;
        private String traceHeader;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsRequestEntry model) {
            this.time(model.time);
            this.source(model.source);
            this.resources(model.resources);
            this.detailType(model.detailType);
            this.detail(model.detail);
            this.eventBusName(model.eventBusName);
            this.traceHeader(model.traceHeader);
        }

        public final Instant getTime() {
            return this.time;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final Collection<String> getResources() {
            if (this.resources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = EventResourceListCopier.copy(resources);
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = EventResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public final String getDetailType() {
            return this.detailType;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        @Override
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        public final String getDetail() {
            return this.detail;
        }

        public final void setDetail(String detail) {
            this.detail = detail;
        }

        @Override
        public final Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public final String getEventBusName() {
            return this.eventBusName;
        }

        public final void setEventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
        }

        @Override
        public final Builder eventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        public final String getTraceHeader() {
            return this.traceHeader;
        }

        public final void setTraceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
        }

        @Override
        public final Builder traceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
            return this;
        }

        public PutEventsRequestEntry build() {
            return new PutEventsRequestEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PutEventsRequestEntry> {
        public Builder time(Instant var1);

        public Builder source(String var1);

        public Builder resources(Collection<String> var1);

        public Builder resources(String ... var1);

        public Builder detailType(String var1);

        public Builder detail(String var1);

        public Builder eventBusName(String var1);

        public Builder traceHeader(String var1);
    }
}

