/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectionOAuthClientRequestParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateConnectionOAuthClientRequestParameters> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientID").getter(CreateConnectionOAuthClientRequestParameters.getter(CreateConnectionOAuthClientRequestParameters::clientID)).setter(CreateConnectionOAuthClientRequestParameters.setter(Builder::clientID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientID").build()}).build();
    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientSecret").getter(CreateConnectionOAuthClientRequestParameters.getter(CreateConnectionOAuthClientRequestParameters::clientSecret)).setter(CreateConnectionOAuthClientRequestParameters.setter(Builder::clientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSecret").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, CLIENT_SECRET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConnectionOAuthClientRequestParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientID;
    private final String clientSecret;

    private CreateConnectionOAuthClientRequestParameters(BuilderImpl builder) {
        this.clientID = builder.clientID;
        this.clientSecret = builder.clientSecret;
    }

    public final String clientID() {
        return this.clientID;
    }

    public final String clientSecret() {
        return this.clientSecret;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientID());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecret());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionOAuthClientRequestParameters)) {
            return false;
        }
        CreateConnectionOAuthClientRequestParameters other = (CreateConnectionOAuthClientRequestParameters)obj;
        return Objects.equals(this.clientID(), other.clientID()) && Objects.equals(this.clientSecret(), other.clientSecret());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectionOAuthClientRequestParameters").add("ClientID", (Object)this.clientID()).add("ClientSecret", (Object)(this.clientSecret() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientID": {
                return Optional.ofNullable(clazz.cast(this.clientID()));
            }
            case "ClientSecret": {
                return Optional.ofNullable(clazz.cast(this.clientSecret()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ClientID", CLIENT_ID_FIELD);
        map.put("ClientSecret", CLIENT_SECRET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionOAuthClientRequestParameters, T> g) {
        return obj -> g.apply((CreateConnectionOAuthClientRequestParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientID;
        private String clientSecret;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionOAuthClientRequestParameters model) {
            this.clientID(model.clientID);
            this.clientSecret(model.clientSecret);
        }

        public final String getClientID() {
            return this.clientID;
        }

        public final void setClientID(String clientID) {
            this.clientID = clientID;
        }

        @Override
        public final Builder clientID(String clientID) {
            this.clientID = clientID;
            return this;
        }

        public final String getClientSecret() {
            return this.clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public CreateConnectionOAuthClientRequestParameters build() {
            return new CreateConnectionOAuthClientRequestParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateConnectionOAuthClientRequestParameters> {
        public Builder clientID(String var1);

        public Builder clientSecret(String var1);
    }
}

