/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.cloudwatchevents.CloudWatchEventsAsyncClient;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsException;
import software.amazon.awssdk.services.cloudwatchevents.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DeleteRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventBusRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeEventBusResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DescribeRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.DisableRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.DisableRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.EnableRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.EnableRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.InternalException;
import software.amazon.awssdk.services.cloudwatchevents.model.InvalidEventPatternException;
import software.amazon.awssdk.services.cloudwatchevents.model.LimitExceededException;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRuleNamesByTargetRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRuleNamesByTargetResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRulesRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListRulesResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTargetsByRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.ListTargetsByRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ManagedRuleException;
import software.amazon.awssdk.services.cloudwatchevents.model.PolicyLengthExceededException;
import software.amazon.awssdk.services.cloudwatchevents.model.PutEventsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPermissionRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPermissionResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutRuleRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutRuleResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutTargetsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.PutTargetsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.RemovePermissionRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.RemovePermissionResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.RemoveTargetsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.RemoveTargetsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudwatchevents.model.TestEventPatternRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.TestEventPatternResponse;
import software.amazon.awssdk.services.cloudwatchevents.transform.DeleteRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribeEventBusRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DescribeRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.DisableRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.EnableRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListRuleNamesByTargetRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.ListTargetsByRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutPermissionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.PutTargetsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.RemoveTargetsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.transform.TestEventPatternRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCloudWatchEventsAsyncClient
implements CloudWatchEventsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudWatchEventsAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudWatchEventsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "events";
    }

    @Override
    public CompletableFuture<DeleteRuleResponse> deleteRule(DeleteRuleRequest deleteRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRule").withMarshaller((Marshaller)new DeleteRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRuleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEventBusResponse> describeEventBus(DescribeEventBusRequest describeEventBusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventBusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventBus").withMarshaller((Marshaller)new DescribeEventBusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventBusRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRuleResponse> describeRule(DescribeRuleRequest describeRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRule").withMarshaller((Marshaller)new DescribeRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRuleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableRuleResponse> disableRule(DisableRuleRequest disableRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableRule").withMarshaller((Marshaller)new DisableRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableRuleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableRuleResponse> enableRule(EnableRuleRequest enableRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableRule").withMarshaller((Marshaller)new EnableRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableRuleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRuleNamesByTargetResponse> listRuleNamesByTarget(ListRuleNamesByTargetRequest listRuleNamesByTargetRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRuleNamesByTargetResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRuleNamesByTarget").withMarshaller((Marshaller)new ListRuleNamesByTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRuleNamesByTargetRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRulesResponse> listRules(ListRulesRequest listRulesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRulesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRules").withMarshaller((Marshaller)new ListRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRulesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTargetsByRuleResponse> listTargetsByRule(ListTargetsByRuleRequest listTargetsByRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTargetsByRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTargetsByRule").withMarshaller((Marshaller)new ListTargetsByRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTargetsByRuleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutEventsResponse> putEvents(PutEventsRequest putEventsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutEventsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutEvents").withMarshaller((Marshaller)new PutEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEventsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutPermissionResponse> putPermission(PutPermissionRequest putPermissionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPermissionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPermission").withMarshaller((Marshaller)new PutPermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putPermissionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutRuleResponse> putRule(PutRuleRequest putRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRule").withMarshaller((Marshaller)new PutRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRuleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutTargetsResponse> putTargets(PutTargetsRequest putTargetsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutTargetsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutTargets").withMarshaller((Marshaller)new PutTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putTargetsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemovePermissionResponse> removePermission(RemovePermissionRequest removePermissionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemovePermissionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemovePermission").withMarshaller((Marshaller)new RemovePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removePermissionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveTargetsResponse> removeTargets(RemoveTargetsRequest removeTargetsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTargetsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTargets").withMarshaller((Marshaller)new RemoveTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTargetsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TestEventPatternResponse> testEventPattern(TestEventPatternRequest testEventPatternRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestEventPatternResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            return this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestEventPattern").withMarshaller((Marshaller)new TestEventPatternRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testEventPatternRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudWatchEventsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PolicyLengthExceededException").exceptionBuilderSupplier(PolicyLengthExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEventPatternException").exceptionBuilderSupplier(InvalidEventPatternException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalException").exceptionBuilderSupplier(InternalException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ManagedRuleException").exceptionBuilderSupplier(ManagedRuleException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}

