/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPartnerEventsResultEntry;
import software.amazon.awssdk.services.cloudwatchevents.model.PutPartnerEventsResultEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutPartnerEventsResponse
extends CloudWatchEventsResponse
implements ToCopyableBuilder<Builder, PutPartnerEventsResponse> {
    private static final SdkField<Integer> FAILED_ENTRY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedEntryCount").getter(PutPartnerEventsResponse.getter(PutPartnerEventsResponse::failedEntryCount)).setter(PutPartnerEventsResponse.setter(Builder::failedEntryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEntryCount").build()}).build();
    private static final SdkField<List<PutPartnerEventsResultEntry>> ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entries").getter(PutPartnerEventsResponse.getter(PutPartnerEventsResponse::entries)).setter(PutPartnerEventsResponse.setter(Builder::entries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PutPartnerEventsResultEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ENTRY_COUNT_FIELD, ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FailedEntryCount", FAILED_ENTRY_COUNT_FIELD);
            this.put("Entries", ENTRIES_FIELD);
        }
    });
    private final Integer failedEntryCount;
    private final List<PutPartnerEventsResultEntry> entries;

    private PutPartnerEventsResponse(BuilderImpl builder) {
        super(builder);
        this.failedEntryCount = builder.failedEntryCount;
        this.entries = builder.entries;
    }

    public final Integer failedEntryCount() {
        return this.failedEntryCount;
    }

    public final boolean hasEntries() {
        return this.entries != null && !(this.entries instanceof SdkAutoConstructList);
    }

    public final List<PutPartnerEventsResultEntry> entries() {
        return this.entries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.failedEntryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntries() ? this.entries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPartnerEventsResponse)) {
            return false;
        }
        PutPartnerEventsResponse other = (PutPartnerEventsResponse)((Object)obj);
        return Objects.equals(this.failedEntryCount(), other.failedEntryCount()) && this.hasEntries() == other.hasEntries() && Objects.equals(this.entries(), other.entries());
    }

    public final String toString() {
        return ToString.builder((String)"PutPartnerEventsResponse").add("FailedEntryCount", (Object)this.failedEntryCount()).add("Entries", this.hasEntries() ? this.entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedEntryCount": {
                return Optional.ofNullable(clazz.cast(this.failedEntryCount()));
            }
            case "Entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutPartnerEventsResponse, T> g) {
        return obj -> g.apply((PutPartnerEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsResponse.BuilderImpl
    implements Builder {
        private Integer failedEntryCount;
        private List<PutPartnerEventsResultEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutPartnerEventsResponse model) {
            super(model);
            this.failedEntryCount(model.failedEntryCount);
            this.entries(model.entries);
        }

        public final Integer getFailedEntryCount() {
            return this.failedEntryCount;
        }

        public final void setFailedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
        }

        @Override
        public final Builder failedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
            return this;
        }

        public final List<PutPartnerEventsResultEntry.Builder> getEntries() {
            List<PutPartnerEventsResultEntry.Builder> result = PutPartnerEventsResultEntryListCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<PutPartnerEventsResultEntry.BuilderImpl> entries) {
            this.entries = PutPartnerEventsResultEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<PutPartnerEventsResultEntry> entries) {
            this.entries = PutPartnerEventsResultEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(PutPartnerEventsResultEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<PutPartnerEventsResultEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (PutPartnerEventsResultEntry)((PutPartnerEventsResultEntry.Builder)PutPartnerEventsResultEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutPartnerEventsResponse build() {
            return new PutPartnerEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutPartnerEventsResponse> {
        public Builder failedEntryCount(Integer var1);

        public Builder entries(Collection<PutPartnerEventsResultEntry> var1);

        public Builder entries(PutPartnerEventsResultEntry ... var1);

        public Builder entries(Consumer<PutPartnerEventsResultEntry.Builder> ... var1);
    }
}

