/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.EventSourceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventSourceResponse
extends CloudWatchEventsResponse
implements ToCopyableBuilder<Builder, DescribeEventSourceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeEventSourceResponse.getter(DescribeEventSourceResponse::arn)).setter(DescribeEventSourceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(DescribeEventSourceResponse.getter(DescribeEventSourceResponse::createdBy)).setter(DescribeEventSourceResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeEventSourceResponse.getter(DescribeEventSourceResponse::creationTime)).setter(DescribeEventSourceResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationTime").getter(DescribeEventSourceResponse.getter(DescribeEventSourceResponse::expirationTime)).setter(DescribeEventSourceResponse.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeEventSourceResponse.getter(DescribeEventSourceResponse::name)).setter(DescribeEventSourceResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeEventSourceResponse.getter(DescribeEventSourceResponse::stateAsString)).setter(DescribeEventSourceResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_BY_FIELD, CREATION_TIME_FIELD, EXPIRATION_TIME_FIELD, NAME_FIELD, STATE_FIELD));
    private final String arn;
    private final String createdBy;
    private final Instant creationTime;
    private final Instant expirationTime;
    private final String name;
    private final String state;

    private DescribeEventSourceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdBy = builder.createdBy;
        this.creationTime = builder.creationTime;
        this.expirationTime = builder.expirationTime;
        this.name = builder.name;
        this.state = builder.state;
    }

    public final String arn() {
        return this.arn;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant expirationTime() {
        return this.expirationTime;
    }

    public final String name() {
        return this.name;
    }

    public final EventSourceState state() {
        return EventSourceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventSourceResponse)) {
            return false;
        }
        DescribeEventSourceResponse other = (DescribeEventSourceResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEventSourceResponse").add("Arn", (Object)this.arn()).add("CreatedBy", (Object)this.createdBy()).add("CreationTime", (Object)this.creationTime()).add("ExpirationTime", (Object)this.expirationTime()).add("Name", (Object)this.name()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventSourceResponse, T> g) {
        return obj -> g.apply((DescribeEventSourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String createdBy;
        private Instant creationTime;
        private Instant expirationTime;
        private String name;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventSourceResponse model) {
            super(model);
            this.arn(model.arn);
            this.createdBy(model.createdBy);
            this.creationTime(model.creationTime);
            this.expirationTime(model.expirationTime);
            this.name(model.name);
            this.state(model.state);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EventSourceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public DescribeEventSourceResponse build() {
            return new DescribeEventSourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventSourceResponse> {
        public Builder arn(String var1);

        public Builder createdBy(String var1);

        public Builder creationTime(Instant var1);

        public Builder expirationTime(Instant var1);

        public Builder name(String var1);

        public Builder state(String var1);

        public Builder state(EventSourceState var1);
    }
}

