/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchevents.CloudWatchEventsAsyncClient;
import software.amazon.awssdk.services.cloudwatchevents.CloudWatchEventsAsyncClientBuilder;
import software.amazon.awssdk.services.cloudwatchevents.CloudWatchEventsServiceClientConfiguration;
import software.amazon.awssdk.services.cloudwatchevents.DefaultCloudWatchEventsAsyncClient;
import software.amazon.awssdk.services.cloudwatchevents.DefaultCloudWatchEventsBaseClientBuilder;
import software.amazon.awssdk.services.cloudwatchevents.endpoints.CloudWatchEventsEndpointProvider;

@SdkInternalApi
final class DefaultCloudWatchEventsAsyncClientBuilder
extends DefaultCloudWatchEventsBaseClientBuilder<CloudWatchEventsAsyncClientBuilder, CloudWatchEventsAsyncClient>
implements CloudWatchEventsAsyncClientBuilder {
    DefaultCloudWatchEventsAsyncClientBuilder() {
    }

    @Override
    public DefaultCloudWatchEventsAsyncClientBuilder endpointProvider(CloudWatchEventsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudWatchEventsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudWatchEventsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CloudWatchEventsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCloudWatchEventsAsyncClient client = new DefaultCloudWatchEventsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CloudWatchEventsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CloudWatchEventsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

