/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectionApiKeyAuthRequestParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateConnectionApiKeyAuthRequestParameters> {
    private static final SdkField<String> API_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiKeyName").getter(CreateConnectionApiKeyAuthRequestParameters.getter(CreateConnectionApiKeyAuthRequestParameters::apiKeyName)).setter(CreateConnectionApiKeyAuthRequestParameters.setter(Builder::apiKeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeyName").build()}).build();
    private static final SdkField<String> API_KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiKeyValue").getter(CreateConnectionApiKeyAuthRequestParameters.getter(CreateConnectionApiKeyAuthRequestParameters::apiKeyValue)).setter(CreateConnectionApiKeyAuthRequestParameters.setter(Builder::apiKeyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeyValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_NAME_FIELD, API_KEY_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String apiKeyName;
    private final String apiKeyValue;

    private CreateConnectionApiKeyAuthRequestParameters(BuilderImpl builder) {
        this.apiKeyName = builder.apiKeyName;
        this.apiKeyValue = builder.apiKeyValue;
    }

    public final String apiKeyName() {
        return this.apiKeyName;
    }

    public final String apiKeyValue() {
        return this.apiKeyValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionApiKeyAuthRequestParameters)) {
            return false;
        }
        CreateConnectionApiKeyAuthRequestParameters other = (CreateConnectionApiKeyAuthRequestParameters)obj;
        return Objects.equals(this.apiKeyName(), other.apiKeyName()) && Objects.equals(this.apiKeyValue(), other.apiKeyValue());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectionApiKeyAuthRequestParameters").add("ApiKeyName", (Object)this.apiKeyName()).add("ApiKeyValue", (Object)this.apiKeyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiKeyName": {
                return Optional.ofNullable(clazz.cast(this.apiKeyName()));
            }
            case "ApiKeyValue": {
                return Optional.ofNullable(clazz.cast(this.apiKeyValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionApiKeyAuthRequestParameters, T> g) {
        return obj -> g.apply((CreateConnectionApiKeyAuthRequestParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiKeyName;
        private String apiKeyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionApiKeyAuthRequestParameters model) {
            this.apiKeyName(model.apiKeyName);
            this.apiKeyValue(model.apiKeyValue);
        }

        public final String getApiKeyName() {
            return this.apiKeyName;
        }

        @Override
        public final Builder apiKeyName(String apiKeyName) {
            this.apiKeyName = apiKeyName;
            return this;
        }

        public final void setApiKeyName(String apiKeyName) {
            this.apiKeyName = apiKeyName;
        }

        public final String getApiKeyValue() {
            return this.apiKeyValue;
        }

        @Override
        public final Builder apiKeyValue(String apiKeyValue) {
            this.apiKeyValue = apiKeyValue;
            return this;
        }

        public final void setApiKeyValue(String apiKeyValue) {
            this.apiKeyValue = apiKeyValue;
        }

        public CreateConnectionApiKeyAuthRequestParameters build() {
            return new CreateConnectionApiKeyAuthRequestParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateConnectionApiKeyAuthRequestParameters> {
        public Builder apiKeyName(String var1);

        public Builder apiKeyValue(String var1);
    }
}

