/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionApiKeyAuthResponseParameters;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionBasicAuthResponseParameters;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionHttpParameters;
import software.amazon.awssdk.services.cloudwatchevents.model.ConnectionOAuthResponseParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionAuthResponseParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionAuthResponseParameters> {
    private static final SdkField<ConnectionBasicAuthResponseParameters> BASIC_AUTH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BasicAuthParameters").getter(ConnectionAuthResponseParameters.getter(ConnectionAuthResponseParameters::basicAuthParameters)).setter(ConnectionAuthResponseParameters.setter(Builder::basicAuthParameters)).constructor(ConnectionBasicAuthResponseParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthParameters").build()}).build();
    private static final SdkField<ConnectionOAuthResponseParameters> O_AUTH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OAuthParameters").getter(ConnectionAuthResponseParameters.getter(ConnectionAuthResponseParameters::oAuthParameters)).setter(ConnectionAuthResponseParameters.setter(Builder::oAuthParameters)).constructor(ConnectionOAuthResponseParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthParameters").build()}).build();
    private static final SdkField<ConnectionApiKeyAuthResponseParameters> API_KEY_AUTH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApiKeyAuthParameters").getter(ConnectionAuthResponseParameters.getter(ConnectionAuthResponseParameters::apiKeyAuthParameters)).setter(ConnectionAuthResponseParameters.setter(Builder::apiKeyAuthParameters)).constructor(ConnectionApiKeyAuthResponseParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeyAuthParameters").build()}).build();
    private static final SdkField<ConnectionHttpParameters> INVOCATION_HTTP_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InvocationHttpParameters").getter(ConnectionAuthResponseParameters.getter(ConnectionAuthResponseParameters::invocationHttpParameters)).setter(ConnectionAuthResponseParameters.setter(Builder::invocationHttpParameters)).constructor(ConnectionHttpParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationHttpParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASIC_AUTH_PARAMETERS_FIELD, O_AUTH_PARAMETERS_FIELD, API_KEY_AUTH_PARAMETERS_FIELD, INVOCATION_HTTP_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ConnectionBasicAuthResponseParameters basicAuthParameters;
    private final ConnectionOAuthResponseParameters oAuthParameters;
    private final ConnectionApiKeyAuthResponseParameters apiKeyAuthParameters;
    private final ConnectionHttpParameters invocationHttpParameters;

    private ConnectionAuthResponseParameters(BuilderImpl builder) {
        this.basicAuthParameters = builder.basicAuthParameters;
        this.oAuthParameters = builder.oAuthParameters;
        this.apiKeyAuthParameters = builder.apiKeyAuthParameters;
        this.invocationHttpParameters = builder.invocationHttpParameters;
    }

    public final ConnectionBasicAuthResponseParameters basicAuthParameters() {
        return this.basicAuthParameters;
    }

    public final ConnectionOAuthResponseParameters oAuthParameters() {
        return this.oAuthParameters;
    }

    public final ConnectionApiKeyAuthResponseParameters apiKeyAuthParameters() {
        return this.apiKeyAuthParameters;
    }

    public final ConnectionHttpParameters invocationHttpParameters() {
        return this.invocationHttpParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyAuthParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationHttpParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionAuthResponseParameters)) {
            return false;
        }
        ConnectionAuthResponseParameters other = (ConnectionAuthResponseParameters)obj;
        return Objects.equals(this.basicAuthParameters(), other.basicAuthParameters()) && Objects.equals(this.oAuthParameters(), other.oAuthParameters()) && Objects.equals(this.apiKeyAuthParameters(), other.apiKeyAuthParameters()) && Objects.equals(this.invocationHttpParameters(), other.invocationHttpParameters());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionAuthResponseParameters").add("BasicAuthParameters", (Object)this.basicAuthParameters()).add("OAuthParameters", (Object)this.oAuthParameters()).add("ApiKeyAuthParameters", (Object)this.apiKeyAuthParameters()).add("InvocationHttpParameters", (Object)this.invocationHttpParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BasicAuthParameters": {
                return Optional.ofNullable(clazz.cast(this.basicAuthParameters()));
            }
            case "OAuthParameters": {
                return Optional.ofNullable(clazz.cast(this.oAuthParameters()));
            }
            case "ApiKeyAuthParameters": {
                return Optional.ofNullable(clazz.cast(this.apiKeyAuthParameters()));
            }
            case "InvocationHttpParameters": {
                return Optional.ofNullable(clazz.cast(this.invocationHttpParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionAuthResponseParameters, T> g) {
        return obj -> g.apply((ConnectionAuthResponseParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConnectionBasicAuthResponseParameters basicAuthParameters;
        private ConnectionOAuthResponseParameters oAuthParameters;
        private ConnectionApiKeyAuthResponseParameters apiKeyAuthParameters;
        private ConnectionHttpParameters invocationHttpParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionAuthResponseParameters model) {
            this.basicAuthParameters(model.basicAuthParameters);
            this.oAuthParameters(model.oAuthParameters);
            this.apiKeyAuthParameters(model.apiKeyAuthParameters);
            this.invocationHttpParameters(model.invocationHttpParameters);
        }

        public final ConnectionBasicAuthResponseParameters.Builder getBasicAuthParameters() {
            return this.basicAuthParameters != null ? this.basicAuthParameters.toBuilder() : null;
        }

        @Override
        public final Builder basicAuthParameters(ConnectionBasicAuthResponseParameters basicAuthParameters) {
            this.basicAuthParameters = basicAuthParameters;
            return this;
        }

        public final void setBasicAuthParameters(ConnectionBasicAuthResponseParameters.BuilderImpl basicAuthParameters) {
            this.basicAuthParameters = basicAuthParameters != null ? basicAuthParameters.build() : null;
        }

        public final ConnectionOAuthResponseParameters.Builder getOAuthParameters() {
            return this.oAuthParameters != null ? this.oAuthParameters.toBuilder() : null;
        }

        @Override
        public final Builder oAuthParameters(ConnectionOAuthResponseParameters oAuthParameters) {
            this.oAuthParameters = oAuthParameters;
            return this;
        }

        public final void setOAuthParameters(ConnectionOAuthResponseParameters.BuilderImpl oAuthParameters) {
            this.oAuthParameters = oAuthParameters != null ? oAuthParameters.build() : null;
        }

        public final ConnectionApiKeyAuthResponseParameters.Builder getApiKeyAuthParameters() {
            return this.apiKeyAuthParameters != null ? this.apiKeyAuthParameters.toBuilder() : null;
        }

        @Override
        public final Builder apiKeyAuthParameters(ConnectionApiKeyAuthResponseParameters apiKeyAuthParameters) {
            this.apiKeyAuthParameters = apiKeyAuthParameters;
            return this;
        }

        public final void setApiKeyAuthParameters(ConnectionApiKeyAuthResponseParameters.BuilderImpl apiKeyAuthParameters) {
            this.apiKeyAuthParameters = apiKeyAuthParameters != null ? apiKeyAuthParameters.build() : null;
        }

        public final ConnectionHttpParameters.Builder getInvocationHttpParameters() {
            return this.invocationHttpParameters != null ? this.invocationHttpParameters.toBuilder() : null;
        }

        @Override
        public final Builder invocationHttpParameters(ConnectionHttpParameters invocationHttpParameters) {
            this.invocationHttpParameters = invocationHttpParameters;
            return this;
        }

        public final void setInvocationHttpParameters(ConnectionHttpParameters.BuilderImpl invocationHttpParameters) {
            this.invocationHttpParameters = invocationHttpParameters != null ? invocationHttpParameters.build() : null;
        }

        public ConnectionAuthResponseParameters build() {
            return new ConnectionAuthResponseParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionAuthResponseParameters> {
        public Builder basicAuthParameters(ConnectionBasicAuthResponseParameters var1);

        default public Builder basicAuthParameters(Consumer<ConnectionBasicAuthResponseParameters.Builder> basicAuthParameters) {
            return this.basicAuthParameters((ConnectionBasicAuthResponseParameters)((ConnectionBasicAuthResponseParameters.Builder)ConnectionBasicAuthResponseParameters.builder().applyMutation(basicAuthParameters)).build());
        }

        public Builder oAuthParameters(ConnectionOAuthResponseParameters var1);

        default public Builder oAuthParameters(Consumer<ConnectionOAuthResponseParameters.Builder> oAuthParameters) {
            return this.oAuthParameters((ConnectionOAuthResponseParameters)((ConnectionOAuthResponseParameters.Builder)ConnectionOAuthResponseParameters.builder().applyMutation(oAuthParameters)).build());
        }

        public Builder apiKeyAuthParameters(ConnectionApiKeyAuthResponseParameters var1);

        default public Builder apiKeyAuthParameters(Consumer<ConnectionApiKeyAuthResponseParameters.Builder> apiKeyAuthParameters) {
            return this.apiKeyAuthParameters((ConnectionApiKeyAuthResponseParameters)((ConnectionApiKeyAuthResponseParameters.Builder)ConnectionApiKeyAuthResponseParameters.builder().applyMutation(apiKeyAuthParameters)).build());
        }

        public Builder invocationHttpParameters(ConnectionHttpParameters var1);

        default public Builder invocationHttpParameters(Consumer<ConnectionHttpParameters.Builder> invocationHttpParameters) {
            return this.invocationHttpParameters((ConnectionHttpParameters)((ConnectionHttpParameters.Builder)ConnectionHttpParameters.builder().applyMutation(invocationHttpParameters)).build());
        }
    }
}

