/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.Target;
import software.amazon.awssdk.services.cloudwatchevents.model.TargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutTargetsRequest
extends CloudWatchEventsRequest
implements ToCopyableBuilder<Builder, PutTargetsRequest> {
    private static final SdkField<String> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Rule").getter(PutTargetsRequest.getter(PutTargetsRequest::rule)).setter(PutTargetsRequest.setter(Builder::rule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()}).build();
    private static final SdkField<String> EVENT_BUS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventBusName").getter(PutTargetsRequest.getter(PutTargetsRequest::eventBusName)).setter(PutTargetsRequest.setter(Builder::eventBusName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusName").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(PutTargetsRequest.getter(PutTargetsRequest::targets)).setter(PutTargetsRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_FIELD, EVENT_BUS_NAME_FIELD, TARGETS_FIELD));
    private final String rule;
    private final String eventBusName;
    private final List<Target> targets;

    private PutTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.rule = builder.rule;
        this.eventBusName = builder.eventBusName;
        this.targets = builder.targets;
    }

    public String rule() {
        return this.rule;
    }

    public String eventBusName() {
        return this.eventBusName;
    }

    public boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public List<Target> targets() {
        return this.targets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBusName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTargetsRequest)) {
            return false;
        }
        PutTargetsRequest other = (PutTargetsRequest)((Object)obj);
        return Objects.equals(this.rule(), other.rule()) && Objects.equals(this.eventBusName(), other.eventBusName()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets());
    }

    public String toString() {
        return ToString.builder((String)"PutTargetsRequest").add("Rule", (Object)this.rule()).add("EventBusName", (Object)this.eventBusName()).add("Targets", this.hasTargets() ? this.targets() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "EventBusName": {
                return Optional.ofNullable(clazz.cast(this.eventBusName()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutTargetsRequest, T> g) {
        return obj -> g.apply((PutTargetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchEventsRequest.BuilderImpl
    implements Builder {
        private String rule;
        private String eventBusName;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutTargetsRequest model) {
            super(model);
            this.rule(model.rule);
            this.eventBusName(model.eventBusName);
            this.targets(model.targets);
        }

        public final String getRule() {
            return this.rule;
        }

        @Override
        public final Builder rule(String rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(String rule) {
            this.rule = rule;
        }

        public final String getEventBusName() {
            return this.eventBusName;
        }

        @Override
        public final Builder eventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        public final void setEventBusName(String eventBusName) {
            this.eventBusName = eventBusName;
        }

        public final Collection<Target.Builder> getTargets() {
            if (this.targets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetListCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetListCopier.copyFromBuilder(targets);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTargetsRequest build() {
            return new PutTargetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutTargetsRequest> {
        public Builder rule(String var1);

        public Builder eventBusName(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

