/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.MessageData;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataResult;

public class GetMetricDataPublisher
implements SdkPublisher<GetMetricDataResponse> {
    private final CloudWatchAsyncClient client;
    private final GetMetricDataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetMetricDataPublisher(CloudWatchAsyncClient client, GetMetricDataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetMetricDataPublisher(CloudWatchAsyncClient client, GetMetricDataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetMetricDataResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetMetricDataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetricDataResult> metricDataResults() {
        return this.flatMapIterable(response -> response.metricDataResults());
    }

    public final SdkPublisher<MessageData> messages() {
        return this.flatMapIterable(response -> response.messages());
    }

    private class GetMetricDataResponseFetcher
    implements AsyncPageFetcher<GetMetricDataResponse> {
        private GetMetricDataResponseFetcher() {
        }

        public boolean hasNextPage(GetMetricDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetMetricDataResponse> nextPage(GetMetricDataResponse previousPage) {
            if (previousPage == null) {
                return GetMetricDataPublisher.this.client.getMetricData(GetMetricDataPublisher.this.firstRequest);
            }
            return GetMetricDataPublisher.this.client.getMetricData((GetMetricDataRequest)((Object)GetMetricDataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

