/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.internal.interceptor.trait.RequestCompression;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.protocols.rpcv2.SmithyRpcV2CborProtocolFactory;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchServiceClientConfiguration;
import software.amazon.awssdk.services.cloudwatch.internal.CloudWatchServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchException;
import software.amazon.awssdk.services.cloudwatch.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudwatch.model.ConflictException;
import software.amazon.awssdk.services.cloudwatch.model.DashboardInvalidInputErrorException;
import software.amazon.awssdk.services.cloudwatch.model.DashboardNotFoundErrorException;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmContributorsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmContributorsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse;
import software.amazon.awssdk.services.cloudwatch.model.InternalServiceException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidFormatException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidNextTokenException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidParameterValueException;
import software.amazon.awssdk.services.cloudwatch.model.LimitExceededException;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudwatch.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.cloudwatch.model.PutAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamResponse;
import software.amazon.awssdk.services.cloudwatch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateResponse;
import software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest;
import software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsResponse;
import software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest;
import software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsResponse;
import software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudwatch.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudwatch.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudwatch.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteAlarmsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteDashboardsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteInsightRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteMetricStreamRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmContributorsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmHistoryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsForMetricRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAnomalyDetectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeInsightRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DisableAlarmActionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DisableInsightRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.EnableAlarmActionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.EnableInsightRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetInsightRuleReportRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricDataRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricStatisticsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricStreamRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricWidgetImageRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListDashboardsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListManagedInsightRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListMetricStreamsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListMetricsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutCompositeAlarmRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutInsightRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutManagedInsightRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricAlarmRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricDataRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricStreamRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.SetAlarmStateRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.StartMetricStreamsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.StopMetricStreamsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.waiters.CloudWatchWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCloudWatchClient
implements CloudWatchClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudWatchClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.SMITHY_RPC_V2_CBOR).build();
    private final SyncClientHandler clientHandler;
    private final SmithyRpcV2CborProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudWatchClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CloudWatch#2.41.x").build();
        this.protocolFactory = this.init(SmithyRpcV2CborProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAlarmsResponse deleteAlarms(DeleteAlarmsRequest deleteAlarmsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAlarmsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAlarmsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, deleteAlarmsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAlarms");
            DeleteAlarmsResponse deleteAlarmsResponse = (DeleteAlarmsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAlarms").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAlarmsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAlarmsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAlarmsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$deleteAlarms$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAnomalyDetectorResponse deleteAnomalyDetector(DeleteAnomalyDetectorRequest deleteAnomalyDetectorRequest) throws ResourceNotFoundException, InternalServiceException, InvalidParameterValueException, MissingRequiredParameterException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAnomalyDetectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAnomalyDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, deleteAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAnomalyDetector");
            DeleteAnomalyDetectorResponse deleteAnomalyDetectorResponse = (DeleteAnomalyDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnomalyDetector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAnomalyDetectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAnomalyDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAnomalyDetectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$deleteAnomalyDetector$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDashboardsResponse deleteDashboards(DeleteDashboardsRequest deleteDashboardsRequest) throws InvalidParameterValueException, DashboardNotFoundErrorException, InternalServiceException, ConflictException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDashboardsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDashboardsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, deleteDashboardsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDashboards");
            DeleteDashboardsResponse deleteDashboardsResponse = (DeleteDashboardsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDashboards").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDashboardsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDashboardsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDashboardsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$deleteDashboards$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInsightRulesResponse deleteInsightRules(DeleteInsightRulesRequest deleteInsightRulesRequest) throws InvalidParameterValueException, MissingRequiredParameterException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInsightRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInsightRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, deleteInsightRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInsightRules");
            DeleteInsightRulesResponse deleteInsightRulesResponse = (DeleteInsightRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInsightRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteInsightRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteInsightRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteInsightRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$deleteInsightRules$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMetricStreamResponse deleteMetricStream(DeleteMetricStreamRequest deleteMetricStreamRequest) throws InternalServiceException, InvalidParameterValueException, MissingRequiredParameterException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMetricStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMetricStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, deleteMetricStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMetricStream");
            DeleteMetricStreamResponse deleteMetricStreamResponse = (DeleteMetricStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMetricStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteMetricStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMetricStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMetricStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$deleteMetricStream$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlarmContributorsResponse describeAlarmContributors(DescribeAlarmContributorsRequest describeAlarmContributorsRequest) throws InvalidNextTokenException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAlarmContributorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAlarmContributorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, describeAlarmContributorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAlarmContributors");
            DescribeAlarmContributorsResponse describeAlarmContributorsResponse = (DescribeAlarmContributorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlarmContributors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAlarmContributorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAlarmContributorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAlarmContributorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$describeAlarmContributors$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlarmHistoryResponse describeAlarmHistory(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAlarmHistoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAlarmHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, describeAlarmHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAlarmHistory");
            DescribeAlarmHistoryResponse describeAlarmHistoryResponse = (DescribeAlarmHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlarmHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAlarmHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAlarmHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAlarmHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$describeAlarmHistory$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlarmsResponse describeAlarms(DescribeAlarmsRequest describeAlarmsRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAlarmsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAlarmsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, describeAlarmsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAlarms");
            DescribeAlarmsResponse describeAlarmsResponse = (DescribeAlarmsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlarms").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAlarmsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAlarmsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAlarmsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$describeAlarms$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlarmsForMetricResponse describeAlarmsForMetric(DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) throws AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAlarmsForMetricResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAlarmsForMetricRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, describeAlarmsForMetricRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAlarmsForMetric");
            DescribeAlarmsForMetricResponse describeAlarmsForMetricResponse = (DescribeAlarmsForMetricResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlarmsForMetric").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAlarmsForMetricRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAlarmsForMetricRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAlarmsForMetricResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$describeAlarmsForMetric$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAnomalyDetectorsResponse describeAnomalyDetectors(DescribeAnomalyDetectorsRequest describeAnomalyDetectorsRequest) throws InvalidNextTokenException, InternalServiceException, InvalidParameterValueException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAnomalyDetectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAnomalyDetectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, describeAnomalyDetectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAnomalyDetectors");
            DescribeAnomalyDetectorsResponse describeAnomalyDetectorsResponse = (DescribeAnomalyDetectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAnomalyDetectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAnomalyDetectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAnomalyDetectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAnomalyDetectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$describeAnomalyDetectors$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInsightRulesResponse describeInsightRules(DescribeInsightRulesRequest describeInsightRulesRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInsightRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInsightRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, describeInsightRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInsightRules");
            DescribeInsightRulesResponse describeInsightRulesResponse = (DescribeInsightRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInsightRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeInsightRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInsightRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeInsightRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$describeInsightRules$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableAlarmActionsResponse disableAlarmActions(DisableAlarmActionsRequest disableAlarmActionsRequest) throws AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableAlarmActionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableAlarmActionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, disableAlarmActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableAlarmActions");
            DisableAlarmActionsResponse disableAlarmActionsResponse = (DisableAlarmActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableAlarmActions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableAlarmActionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableAlarmActionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableAlarmActionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$disableAlarmActions$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableInsightRulesResponse disableInsightRules(DisableInsightRulesRequest disableInsightRulesRequest) throws InvalidParameterValueException, MissingRequiredParameterException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableInsightRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableInsightRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, disableInsightRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableInsightRules");
            DisableInsightRulesResponse disableInsightRulesResponse = (DisableInsightRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableInsightRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableInsightRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableInsightRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableInsightRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$disableInsightRules$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableAlarmActionsResponse enableAlarmActions(EnableAlarmActionsRequest enableAlarmActionsRequest) throws AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableAlarmActionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableAlarmActionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, enableAlarmActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableAlarmActions");
            EnableAlarmActionsResponse enableAlarmActionsResponse = (EnableAlarmActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAlarmActions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableAlarmActionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableAlarmActionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableAlarmActionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$enableAlarmActions$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableInsightRulesResponse enableInsightRules(EnableInsightRulesRequest enableInsightRulesRequest) throws InvalidParameterValueException, MissingRequiredParameterException, LimitExceededException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableInsightRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableInsightRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, enableInsightRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableInsightRules");
            EnableInsightRulesResponse enableInsightRulesResponse = (EnableInsightRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableInsightRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableInsightRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableInsightRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableInsightRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$enableInsightRules$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDashboardResponse getDashboard(GetDashboardRequest getDashboardRequest) throws InvalidParameterValueException, DashboardNotFoundErrorException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDashboardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDashboardRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, getDashboardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDashboard");
            GetDashboardResponse getDashboardResponse = (GetDashboardResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDashboard").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDashboardRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDashboardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDashboardResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$getDashboard$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInsightRuleReportResponse getInsightRuleReport(GetInsightRuleReportRequest getInsightRuleReportRequest) throws InvalidParameterValueException, MissingRequiredParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInsightRuleReportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInsightRuleReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, getInsightRuleReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInsightRuleReport");
            GetInsightRuleReportResponse getInsightRuleReportResponse = (GetInsightRuleReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInsightRuleReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInsightRuleReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInsightRuleReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInsightRuleReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$getInsightRuleReport$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMetricDataResponse getMetricData(GetMetricDataRequest getMetricDataRequest) throws InvalidNextTokenException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMetricDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, getMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMetricData");
            GetMetricDataResponse getMetricDataResponse = (GetMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMetricDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMetricDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$getMetricData$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMetricStatisticsResponse getMetricStatistics(GetMetricStatisticsRequest getMetricStatisticsRequest) throws InvalidParameterValueException, MissingRequiredParameterException, InvalidParameterCombinationException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMetricStatisticsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMetricStatisticsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, getMetricStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMetricStatistics");
            GetMetricStatisticsResponse getMetricStatisticsResponse = (GetMetricStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMetricStatistics").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMetricStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMetricStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMetricStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$getMetricStatistics$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMetricStreamResponse getMetricStream(GetMetricStreamRequest getMetricStreamRequest) throws ResourceNotFoundException, InternalServiceException, InvalidParameterValueException, MissingRequiredParameterException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMetricStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMetricStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, getMetricStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMetricStream");
            GetMetricStreamResponse getMetricStreamResponse = (GetMetricStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMetricStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMetricStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMetricStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMetricStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$getMetricStream$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMetricWidgetImageResponse getMetricWidgetImage(GetMetricWidgetImageRequest getMetricWidgetImageRequest) throws AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMetricWidgetImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMetricWidgetImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, getMetricWidgetImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMetricWidgetImage");
            GetMetricWidgetImageResponse getMetricWidgetImageResponse = (GetMetricWidgetImageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMetricWidgetImage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMetricWidgetImageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMetricWidgetImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMetricWidgetImageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$getMetricWidgetImage$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDashboardsResponse listDashboards(ListDashboardsRequest listDashboardsRequest) throws InvalidParameterValueException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDashboardsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDashboardsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, listDashboardsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDashboards");
            ListDashboardsResponse listDashboardsResponse = (ListDashboardsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDashboards").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDashboardsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDashboardsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDashboardsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$listDashboards$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListManagedInsightRulesResponse listManagedInsightRules(ListManagedInsightRulesRequest listManagedInsightRulesRequest) throws InvalidParameterValueException, MissingRequiredParameterException, InvalidNextTokenException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListManagedInsightRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listManagedInsightRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, listManagedInsightRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListManagedInsightRules");
            ListManagedInsightRulesResponse listManagedInsightRulesResponse = (ListManagedInsightRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListManagedInsightRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listManagedInsightRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListManagedInsightRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listManagedInsightRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$listManagedInsightRules$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMetricStreamsResponse listMetricStreams(ListMetricStreamsRequest listMetricStreamsRequest) throws InvalidNextTokenException, InternalServiceException, InvalidParameterValueException, MissingRequiredParameterException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMetricStreamsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMetricStreamsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, listMetricStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMetricStreams");
            ListMetricStreamsResponse listMetricStreamsResponse = (ListMetricStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMetricStreams").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listMetricStreamsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMetricStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMetricStreamsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$listMetricStreams$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMetricsResponse listMetrics(ListMetricsRequest listMetricsRequest) throws InternalServiceException, InvalidParameterValueException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMetricsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMetricsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, listMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMetrics");
            ListMetricsResponse listMetricsResponse = (ListMetricsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMetrics").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listMetricsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMetricsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$listMetrics$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidParameterValueException, ResourceNotFoundException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$listTagsForResource$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAnomalyDetectorResponse putAnomalyDetector(PutAnomalyDetectorRequest putAnomalyDetectorRequest) throws LimitExceededException, InternalServiceException, InvalidParameterValueException, MissingRequiredParameterException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAnomalyDetectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAnomalyDetectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, putAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAnomalyDetector");
            PutAnomalyDetectorResponse putAnomalyDetectorResponse = (PutAnomalyDetectorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAnomalyDetector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAnomalyDetectorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAnomalyDetectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAnomalyDetectorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$putAnomalyDetector$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutCompositeAlarmResponse putCompositeAlarm(PutCompositeAlarmRequest putCompositeAlarmRequest) throws LimitExceededException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutCompositeAlarmResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putCompositeAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, putCompositeAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutCompositeAlarm");
            PutCompositeAlarmResponse putCompositeAlarmResponse = (PutCompositeAlarmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutCompositeAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putCompositeAlarmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutCompositeAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putCompositeAlarmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$putCompositeAlarm$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutDashboardResponse putDashboard(PutDashboardRequest putDashboardRequest) throws DashboardInvalidInputErrorException, InternalServiceException, ConflictException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDashboardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDashboardRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, putDashboardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDashboard");
            PutDashboardResponse putDashboardResponse = (PutDashboardResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDashboard").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putDashboardRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutDashboardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putDashboardResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$putDashboard$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutInsightRuleResponse putInsightRule(PutInsightRuleRequest putInsightRuleRequest) throws InvalidParameterValueException, MissingRequiredParameterException, LimitExceededException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutInsightRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putInsightRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, putInsightRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutInsightRule");
            PutInsightRuleResponse putInsightRuleResponse = (PutInsightRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutInsightRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putInsightRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutInsightRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putInsightRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$putInsightRule$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutManagedInsightRulesResponse putManagedInsightRules(PutManagedInsightRulesRequest putManagedInsightRulesRequest) throws InvalidParameterValueException, MissingRequiredParameterException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutManagedInsightRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putManagedInsightRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, putManagedInsightRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutManagedInsightRules");
            PutManagedInsightRulesResponse putManagedInsightRulesResponse = (PutManagedInsightRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutManagedInsightRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putManagedInsightRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutManagedInsightRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putManagedInsightRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$putManagedInsightRules$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutMetricAlarmResponse putMetricAlarm(PutMetricAlarmRequest putMetricAlarmRequest) throws LimitExceededException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutMetricAlarmResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putMetricAlarmRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, putMetricAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutMetricAlarm");
            PutMetricAlarmResponse putMetricAlarmResponse = (PutMetricAlarmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMetricAlarm").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putMetricAlarmRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutMetricAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putMetricAlarmResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$putMetricAlarm$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutMetricDataResponse putMetricData(PutMetricDataRequest putMetricDataRequest) throws InvalidParameterValueException, MissingRequiredParameterException, InvalidParameterCombinationException, InternalServiceException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutMetricDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, putMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutMetricData");
            PutMetricDataResponse putMetricDataResponse = (PutMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putMetricDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.REQUEST_COMPRESSION, (Object)RequestCompression.builder().encodings(new String[]{"gzip"}).isStreaming(false).build()).withMarshaller((Marshaller)new PutMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putMetricDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$putMetricData$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutMetricStreamResponse putMetricStream(PutMetricStreamRequest putMetricStreamRequest) throws ConcurrentModificationException, InternalServiceException, InvalidParameterValueException, MissingRequiredParameterException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutMetricStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putMetricStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, putMetricStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutMetricStream");
            PutMetricStreamResponse putMetricStreamResponse = (PutMetricStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMetricStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putMetricStreamRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutMetricStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putMetricStreamResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$putMetricStream$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetAlarmStateResponse setAlarmState(SetAlarmStateRequest setAlarmStateRequest) throws ResourceNotFoundException, InvalidFormatException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetAlarmStateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setAlarmStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, setAlarmStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetAlarmState");
            SetAlarmStateResponse setAlarmStateResponse = (SetAlarmStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetAlarmState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)setAlarmStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetAlarmStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setAlarmStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$setAlarmState$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMetricStreamsResponse startMetricStreams(StartMetricStreamsRequest startMetricStreamsRequest) throws InternalServiceException, InvalidParameterValueException, MissingRequiredParameterException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMetricStreamsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startMetricStreamsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, startMetricStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMetricStreams");
            StartMetricStreamsResponse startMetricStreamsResponse = (StartMetricStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMetricStreams").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startMetricStreamsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartMetricStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startMetricStreamsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$startMetricStreams$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopMetricStreamsResponse stopMetricStreams(StopMetricStreamsRequest stopMetricStreamsRequest) throws InternalServiceException, InvalidParameterValueException, MissingRequiredParameterException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopMetricStreamsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopMetricStreamsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, stopMetricStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopMetricStreams");
            StopMetricStreamsResponse stopMetricStreamsResponse = (StopMetricStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopMetricStreams").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopMetricStreamsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopMetricStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopMetricStreamsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$stopMetricStreams$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterValueException, ResourceNotFoundException, ConcurrentModificationException, InternalServiceException, ConflictException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$tagResource$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterValueException, ResourceNotFoundException, ConcurrentModificationException, InternalServiceException, ConflictException, AwsServiceException, SdkClientException, CloudWatchException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "InvalidFormatFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFormatFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFormatException::builder).build());
                }
                case "MissingRequiredParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingRequiredParameterException::builder).build());
                }
                case "InvalidNextToken": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededFault").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "DashboardNotFoundError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardNotFoundError").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).build());
                }
                case "DashboardInvalidInputError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DashboardInvalidInputError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).build());
                }
                case "InternalServiceFault": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceFault").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudWatchClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchClient.lambda$untagResource$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public CloudWatchWaiter waiter() {
        return CloudWatchWaiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "monitoring";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CloudWatchServiceClientConfigurationBuilder serviceConfigBuilder = new CloudWatchServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudWatchException::builder).protocol(AwsJsonProtocol.SMITHY_RPC_V2_CBOR).protocolVersion("1.0").hasAwsQueryCompatible(true);
    }

    @Override
    public final CloudWatchServiceClientConfiguration serviceClientConfiguration() {
        return new CloudWatchServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$untagResource$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopMetricStreams$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMetricStreams$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setAlarmState$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putMetricStream$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putMetricData$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putMetricAlarm$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putManagedInsightRules$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putInsightRule$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDashboard$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putCompositeAlarm$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAnomalyDetector$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMetrics$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMetricStreams$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listManagedInsightRules$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDashboards$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMetricWidgetImage$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMetricStream$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMetricStatistics$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMetricData$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInsightRuleReport$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDashboard$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableInsightRules$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableAlarmActions$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableInsightRules$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableAlarmActions$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInsightRules$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAnomalyDetectors$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAlarmsForMetric$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAlarms$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAlarmHistory$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAlarmContributors$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMetricStream$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInsightRules$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDashboards$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAnomalyDetector$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAlarms$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

