/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAnomalyDetectorRequest extends CloudWatchRequest implements
        ToCopyableBuilder<PutAnomalyDetectorRequest.Builder, PutAnomalyDetectorRequest> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(PutAnomalyDetectorRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(PutAnomalyDetectorRequest::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField
            .<List<Dimension>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(PutAnomalyDetectorRequest::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Dimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(Dimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stat")
            .getter(getter(PutAnomalyDetectorRequest::stat)).setter(setter(Builder::stat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stat").build()).build();

    private static final SdkField<AnomalyDetectorConfiguration> CONFIGURATION_FIELD = SdkField
            .<AnomalyDetectorConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(PutAnomalyDetectorRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(AnomalyDetectorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<MetricCharacteristics> METRIC_CHARACTERISTICS_FIELD = SdkField
            .<MetricCharacteristics> builder(MarshallingType.SDK_POJO).memberName("MetricCharacteristics")
            .getter(getter(PutAnomalyDetectorRequest::metricCharacteristics)).setter(setter(Builder::metricCharacteristics))
            .constructor(MetricCharacteristics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricCharacteristics").build())
            .build();

    private static final SdkField<SingleMetricAnomalyDetector> SINGLE_METRIC_ANOMALY_DETECTOR_FIELD = SdkField
            .<SingleMetricAnomalyDetector> builder(MarshallingType.SDK_POJO)
            .memberName("SingleMetricAnomalyDetector")
            .getter(getter(PutAnomalyDetectorRequest::singleMetricAnomalyDetector))
            .setter(setter(Builder::singleMetricAnomalyDetector))
            .constructor(SingleMetricAnomalyDetector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleMetricAnomalyDetector")
                    .build()).build();

    private static final SdkField<MetricMathAnomalyDetector> METRIC_MATH_ANOMALY_DETECTOR_FIELD = SdkField
            .<MetricMathAnomalyDetector> builder(MarshallingType.SDK_POJO).memberName("MetricMathAnomalyDetector")
            .getter(getter(PutAnomalyDetectorRequest::metricMathAnomalyDetector))
            .setter(setter(Builder::metricMathAnomalyDetector)).constructor(MetricMathAnomalyDetector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricMathAnomalyDetector").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD,
            METRIC_NAME_FIELD, DIMENSIONS_FIELD, STAT_FIELD, CONFIGURATION_FIELD, METRIC_CHARACTERISTICS_FIELD,
            SINGLE_METRIC_ANOMALY_DETECTOR_FIELD, METRIC_MATH_ANOMALY_DETECTOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String namespace;

    private final String metricName;

    private final List<Dimension> dimensions;

    private final String stat;

    private final AnomalyDetectorConfiguration configuration;

    private final MetricCharacteristics metricCharacteristics;

    private final SingleMetricAnomalyDetector singleMetricAnomalyDetector;

    private final MetricMathAnomalyDetector metricMathAnomalyDetector;

    private PutAnomalyDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.stat = builder.stat;
        this.configuration = builder.configuration;
        this.metricCharacteristics = builder.metricCharacteristics;
        this.singleMetricAnomalyDetector = builder.singleMetricAnomalyDetector;
        this.metricMathAnomalyDetector = builder.metricMathAnomalyDetector;
    }

    /**
     * <p>
     * The namespace of the metric to create the anomaly detection model for.
     * </p>
     * 
     * @return The namespace of the metric to create the anomaly detection model for.
     * @deprecated Use SingleMetricAnomalyDetector.
     */
    @Deprecated
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the metric to create the anomaly detection model for.
     * </p>
     * 
     * @return The name of the metric to create the anomaly detection model for.
     * @deprecated Use SingleMetricAnomalyDetector.
     */
    @Deprecated
    public final String metricName() {
        return metricName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     *
     * @deprecated Use SingleMetricAnomalyDetector.
     */
    @Deprecated
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metric dimensions to create the anomaly detection model for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return The metric dimensions to create the anomaly detection model for.
     * @deprecated Use SingleMetricAnomalyDetector.
     */
    @Deprecated
    public final List<Dimension> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The statistic to use for the metric and the anomaly detection model.
     * </p>
     * 
     * @return The statistic to use for the metric and the anomaly detection model.
     * @deprecated Use SingleMetricAnomalyDetector.
     */
    @Deprecated
    public final String stat() {
        return stat;
    }

    /**
     * <p>
     * The configuration specifies details about how the anomaly detection model is to be trained, including time ranges
     * to exclude when training and updating the model. You can specify as many as 10 time ranges.
     * </p>
     * <p>
     * The configuration can also include the time zone to use for the metric.
     * </p>
     * 
     * @return The configuration specifies details about how the anomaly detection model is to be trained, including
     *         time ranges to exclude when training and updating the model. You can specify as many as 10 time
     *         ranges.</p>
     *         <p>
     *         The configuration can also include the time zone to use for the metric.
     */
    public final AnomalyDetectorConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Use this object to include parameters to provide information about your metric to CloudWatch to help it build
     * more accurate anomaly detection models. Currently, it includes the <code>PeriodicSpikes</code> parameter.
     * </p>
     * 
     * @return Use this object to include parameters to provide information about your metric to CloudWatch to help it
     *         build more accurate anomaly detection models. Currently, it includes the <code>PeriodicSpikes</code>
     *         parameter.
     */
    public final MetricCharacteristics metricCharacteristics() {
        return metricCharacteristics;
    }

    /**
     * <p>
     * A single metric anomaly detector to be created.
     * </p>
     * <p>
     * When using <code>SingleMetricAnomalyDetector</code>, you cannot include the following parameters in the same
     * operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Dimensions</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MetricName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Namespace</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stat</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * the <code>MetricMathAnomalyDetector</code> parameters of <code>PutAnomalyDetectorInput</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Instead, specify the single metric anomaly detector attributes as part of the property
     * <code>SingleMetricAnomalyDetector</code>.
     * </p>
     * 
     * @return A single metric anomaly detector to be created.</p>
     *         <p>
     *         When using <code>SingleMetricAnomalyDetector</code>, you cannot include the following parameters in the
     *         same operation:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Dimensions</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MetricName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Namespace</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stat</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         the <code>MetricMathAnomalyDetector</code> parameters of <code>PutAnomalyDetectorInput</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Instead, specify the single metric anomaly detector attributes as part of the property
     *         <code>SingleMetricAnomalyDetector</code>.
     */
    public final SingleMetricAnomalyDetector singleMetricAnomalyDetector() {
        return singleMetricAnomalyDetector;
    }

    /**
     * <p>
     * The metric math anomaly detector to be created.
     * </p>
     * <p>
     * When using <code>MetricMathAnomalyDetector</code>, you cannot include the following parameters in the same
     * operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Dimensions</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MetricName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Namespace</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stat</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * the <code>SingleMetricAnomalyDetector</code> parameters of <code>PutAnomalyDetectorInput</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Instead, specify the metric math anomaly detector attributes as part of the property
     * <code>MetricMathAnomalyDetector</code>.
     * </p>
     * 
     * @return The metric math anomaly detector to be created.</p>
     *         <p>
     *         When using <code>MetricMathAnomalyDetector</code>, you cannot include the following parameters in the
     *         same operation:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Dimensions</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MetricName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Namespace</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stat</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         the <code>SingleMetricAnomalyDetector</code> parameters of <code>PutAnomalyDetectorInput</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Instead, specify the metric math anomaly detector attributes as part of the property
     *         <code>MetricMathAnomalyDetector</code>.
     */
    public final MetricMathAnomalyDetector metricMathAnomalyDetector() {
        return metricMathAnomalyDetector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stat());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(metricCharacteristics());
        hashCode = 31 * hashCode + Objects.hashCode(singleMetricAnomalyDetector());
        hashCode = 31 * hashCode + Objects.hashCode(metricMathAnomalyDetector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAnomalyDetectorRequest)) {
            return false;
        }
        PutAnomalyDetectorRequest other = (PutAnomalyDetectorRequest) obj;
        return Objects.equals(namespace(), other.namespace()) && Objects.equals(metricName(), other.metricName())
                && hasDimensions() == other.hasDimensions() && Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(stat(), other.stat()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(metricCharacteristics(), other.metricCharacteristics())
                && Objects.equals(singleMetricAnomalyDetector(), other.singleMetricAnomalyDetector())
                && Objects.equals(metricMathAnomalyDetector(), other.metricMathAnomalyDetector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAnomalyDetectorRequest").add("Namespace", namespace()).add("MetricName", metricName())
                .add("Dimensions", hasDimensions() ? dimensions() : null).add("Stat", stat())
                .add("Configuration", configuration()).add("MetricCharacteristics", metricCharacteristics())
                .add("SingleMetricAnomalyDetector", singleMetricAnomalyDetector())
                .add("MetricMathAnomalyDetector", metricMathAnomalyDetector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Stat":
            return Optional.ofNullable(clazz.cast(stat()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "MetricCharacteristics":
            return Optional.ofNullable(clazz.cast(metricCharacteristics()));
        case "SingleMetricAnomalyDetector":
            return Optional.ofNullable(clazz.cast(singleMetricAnomalyDetector()));
        case "MetricMathAnomalyDetector":
            return Optional.ofNullable(clazz.cast(metricMathAnomalyDetector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("Stat", STAT_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        map.put("MetricCharacteristics", METRIC_CHARACTERISTICS_FIELD);
        map.put("SingleMetricAnomalyDetector", SINGLE_METRIC_ANOMALY_DETECTOR_FIELD);
        map.put("MetricMathAnomalyDetector", METRIC_MATH_ANOMALY_DETECTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAnomalyDetectorRequest, T> g) {
        return obj -> g.apply((PutAnomalyDetectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAnomalyDetectorRequest> {
        /**
         * <p>
         * The namespace of the metric to create the anomaly detection model for.
         * </p>
         * 
         * @param namespace
         *        The namespace of the metric to create the anomaly detection model for.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Use SingleMetricAnomalyDetector.
         */
        @Deprecated
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the metric to create the anomaly detection model for.
         * </p>
         * 
         * @param metricName
         *        The name of the metric to create the anomaly detection model for.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Use SingleMetricAnomalyDetector.
         */
        @Deprecated
        Builder metricName(String metricName);

        /**
         * <p>
         * The metric dimensions to create the anomaly detection model for.
         * </p>
         * 
         * @param dimensions
         *        The metric dimensions to create the anomaly detection model for.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Use SingleMetricAnomalyDetector.
         */
        @Deprecated
        Builder dimensions(Collection<Dimension> dimensions);

        /**
         * <p>
         * The metric dimensions to create the anomaly detection model for.
         * </p>
         * 
         * @param dimensions
         *        The metric dimensions to create the anomaly detection model for.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Use SingleMetricAnomalyDetector.
         */
        @Deprecated
        Builder dimensions(Dimension... dimensions);

        /**
         * <p>
         * The metric dimensions to create the anomaly detection model for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatch.model.Dimension.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudwatch.model.Dimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatch.model.Dimension.Builder#build()} is called immediately and
         * its result is passed to {@link #dimensions(List<Dimension>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatch.model.Dimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(java.util.Collection<Dimension>)
         * @deprecated Use SingleMetricAnomalyDetector.
         */
        @Deprecated
        Builder dimensions(Consumer<Dimension.Builder>... dimensions);

        /**
         * <p>
         * The statistic to use for the metric and the anomaly detection model.
         * </p>
         * 
         * @param stat
         *        The statistic to use for the metric and the anomaly detection model.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Use SingleMetricAnomalyDetector.
         */
        @Deprecated
        Builder stat(String stat);

        /**
         * <p>
         * The configuration specifies details about how the anomaly detection model is to be trained, including time
         * ranges to exclude when training and updating the model. You can specify as many as 10 time ranges.
         * </p>
         * <p>
         * The configuration can also include the time zone to use for the metric.
         * </p>
         * 
         * @param configuration
         *        The configuration specifies details about how the anomaly detection model is to be trained, including
         *        time ranges to exclude when training and updating the model. You can specify as many as 10 time
         *        ranges.</p>
         *        <p>
         *        The configuration can also include the time zone to use for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AnomalyDetectorConfiguration configuration);

        /**
         * <p>
         * The configuration specifies details about how the anomaly detection model is to be trained, including time
         * ranges to exclude when training and updating the model. You can specify as many as 10 time ranges.
         * </p>
         * <p>
         * The configuration can also include the time zone to use for the metric.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnomalyDetectorConfiguration.Builder}
         * avoiding the need to create one manually via {@link AnomalyDetectorConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnomalyDetectorConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(AnomalyDetectorConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AnomalyDetectorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AnomalyDetectorConfiguration)
         */
        default Builder configuration(Consumer<AnomalyDetectorConfiguration.Builder> configuration) {
            return configuration(AnomalyDetectorConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Use this object to include parameters to provide information about your metric to CloudWatch to help it build
         * more accurate anomaly detection models. Currently, it includes the <code>PeriodicSpikes</code> parameter.
         * </p>
         * 
         * @param metricCharacteristics
         *        Use this object to include parameters to provide information about your metric to CloudWatch to help
         *        it build more accurate anomaly detection models. Currently, it includes the
         *        <code>PeriodicSpikes</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricCharacteristics(MetricCharacteristics metricCharacteristics);

        /**
         * <p>
         * Use this object to include parameters to provide information about your metric to CloudWatch to help it build
         * more accurate anomaly detection models. Currently, it includes the <code>PeriodicSpikes</code> parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricCharacteristics.Builder} avoiding
         * the need to create one manually via {@link MetricCharacteristics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricCharacteristics.Builder#build()} is called immediately and
         * its result is passed to {@link #metricCharacteristics(MetricCharacteristics)}.
         * 
         * @param metricCharacteristics
         *        a consumer that will call methods on {@link MetricCharacteristics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricCharacteristics(MetricCharacteristics)
         */
        default Builder metricCharacteristics(Consumer<MetricCharacteristics.Builder> metricCharacteristics) {
            return metricCharacteristics(MetricCharacteristics.builder().applyMutation(metricCharacteristics).build());
        }

        /**
         * <p>
         * A single metric anomaly detector to be created.
         * </p>
         * <p>
         * When using <code>SingleMetricAnomalyDetector</code>, you cannot include the following parameters in the same
         * operation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Dimensions</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MetricName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Namespace</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stat</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * the <code>MetricMathAnomalyDetector</code> parameters of <code>PutAnomalyDetectorInput</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Instead, specify the single metric anomaly detector attributes as part of the property
         * <code>SingleMetricAnomalyDetector</code>.
         * </p>
         * 
         * @param singleMetricAnomalyDetector
         *        A single metric anomaly detector to be created.</p>
         *        <p>
         *        When using <code>SingleMetricAnomalyDetector</code>, you cannot include the following parameters in
         *        the same operation:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Dimensions</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MetricName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Namespace</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stat</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        the <code>MetricMathAnomalyDetector</code> parameters of <code>PutAnomalyDetectorInput</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Instead, specify the single metric anomaly detector attributes as part of the property
         *        <code>SingleMetricAnomalyDetector</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleMetricAnomalyDetector(SingleMetricAnomalyDetector singleMetricAnomalyDetector);

        /**
         * <p>
         * A single metric anomaly detector to be created.
         * </p>
         * <p>
         * When using <code>SingleMetricAnomalyDetector</code>, you cannot include the following parameters in the same
         * operation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Dimensions</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MetricName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Namespace</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stat</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * the <code>MetricMathAnomalyDetector</code> parameters of <code>PutAnomalyDetectorInput</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Instead, specify the single metric anomaly detector attributes as part of the property
         * <code>SingleMetricAnomalyDetector</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SingleMetricAnomalyDetector.Builder}
         * avoiding the need to create one manually via {@link SingleMetricAnomalyDetector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingleMetricAnomalyDetector.Builder#build()} is called
         * immediately and its result is passed to {@link #singleMetricAnomalyDetector(SingleMetricAnomalyDetector)}.
         * 
         * @param singleMetricAnomalyDetector
         *        a consumer that will call methods on {@link SingleMetricAnomalyDetector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleMetricAnomalyDetector(SingleMetricAnomalyDetector)
         */
        default Builder singleMetricAnomalyDetector(Consumer<SingleMetricAnomalyDetector.Builder> singleMetricAnomalyDetector) {
            return singleMetricAnomalyDetector(SingleMetricAnomalyDetector.builder().applyMutation(singleMetricAnomalyDetector)
                    .build());
        }

        /**
         * <p>
         * The metric math anomaly detector to be created.
         * </p>
         * <p>
         * When using <code>MetricMathAnomalyDetector</code>, you cannot include the following parameters in the same
         * operation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Dimensions</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MetricName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Namespace</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stat</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * the <code>SingleMetricAnomalyDetector</code> parameters of <code>PutAnomalyDetectorInput</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Instead, specify the metric math anomaly detector attributes as part of the property
         * <code>MetricMathAnomalyDetector</code>.
         * </p>
         * 
         * @param metricMathAnomalyDetector
         *        The metric math anomaly detector to be created.</p>
         *        <p>
         *        When using <code>MetricMathAnomalyDetector</code>, you cannot include the following parameters in the
         *        same operation:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Dimensions</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MetricName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Namespace</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stat</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        the <code>SingleMetricAnomalyDetector</code> parameters of <code>PutAnomalyDetectorInput</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Instead, specify the metric math anomaly detector attributes as part of the property
         *        <code>MetricMathAnomalyDetector</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricMathAnomalyDetector(MetricMathAnomalyDetector metricMathAnomalyDetector);

        /**
         * <p>
         * The metric math anomaly detector to be created.
         * </p>
         * <p>
         * When using <code>MetricMathAnomalyDetector</code>, you cannot include the following parameters in the same
         * operation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Dimensions</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MetricName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Namespace</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stat</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * the <code>SingleMetricAnomalyDetector</code> parameters of <code>PutAnomalyDetectorInput</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Instead, specify the metric math anomaly detector attributes as part of the property
         * <code>MetricMathAnomalyDetector</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricMathAnomalyDetector.Builder}
         * avoiding the need to create one manually via {@link MetricMathAnomalyDetector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricMathAnomalyDetector.Builder#build()} is called immediately
         * and its result is passed to {@link #metricMathAnomalyDetector(MetricMathAnomalyDetector)}.
         * 
         * @param metricMathAnomalyDetector
         *        a consumer that will call methods on {@link MetricMathAnomalyDetector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricMathAnomalyDetector(MetricMathAnomalyDetector)
         */
        default Builder metricMathAnomalyDetector(Consumer<MetricMathAnomalyDetector.Builder> metricMathAnomalyDetector) {
            return metricMathAnomalyDetector(MetricMathAnomalyDetector.builder().applyMutation(metricMathAnomalyDetector).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String namespace;

        private String metricName;

        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();

        private String stat;

        private AnomalyDetectorConfiguration configuration;

        private MetricCharacteristics metricCharacteristics;

        private SingleMetricAnomalyDetector singleMetricAnomalyDetector;

        private MetricMathAnomalyDetector metricMathAnomalyDetector;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAnomalyDetectorRequest model) {
            super(model);
            namespace(model.namespace);
            metricName(model.metricName);
            dimensions(model.dimensions);
            stat(model.stat);
            configuration(model.configuration);
            metricCharacteristics(model.metricCharacteristics);
            singleMetricAnomalyDetector(model.singleMetricAnomalyDetector);
            metricMathAnomalyDetector(model.metricMathAnomalyDetector);
        }

        @Deprecated
        public final String getNamespace() {
            return namespace;
        }

        @Deprecated
        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        @Deprecated
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Deprecated
        public final String getMetricName() {
            return metricName;
        }

        @Deprecated
        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        @Deprecated
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Deprecated
        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        @Deprecated
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder dimensions(Dimension... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder dimensions(Consumer<Dimension.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> Dimension.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final String getStat() {
            return stat;
        }

        @Deprecated
        public final void setStat(String stat) {
            this.stat = stat;
        }

        @Override
        @Deprecated
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        public final AnomalyDetectorConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AnomalyDetectorConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AnomalyDetectorConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final MetricCharacteristics.Builder getMetricCharacteristics() {
            return metricCharacteristics != null ? metricCharacteristics.toBuilder() : null;
        }

        public final void setMetricCharacteristics(MetricCharacteristics.BuilderImpl metricCharacteristics) {
            this.metricCharacteristics = metricCharacteristics != null ? metricCharacteristics.build() : null;
        }

        @Override
        public final Builder metricCharacteristics(MetricCharacteristics metricCharacteristics) {
            this.metricCharacteristics = metricCharacteristics;
            return this;
        }

        public final SingleMetricAnomalyDetector.Builder getSingleMetricAnomalyDetector() {
            return singleMetricAnomalyDetector != null ? singleMetricAnomalyDetector.toBuilder() : null;
        }

        public final void setSingleMetricAnomalyDetector(SingleMetricAnomalyDetector.BuilderImpl singleMetricAnomalyDetector) {
            this.singleMetricAnomalyDetector = singleMetricAnomalyDetector != null ? singleMetricAnomalyDetector.build() : null;
        }

        @Override
        public final Builder singleMetricAnomalyDetector(SingleMetricAnomalyDetector singleMetricAnomalyDetector) {
            this.singleMetricAnomalyDetector = singleMetricAnomalyDetector;
            return this;
        }

        public final MetricMathAnomalyDetector.Builder getMetricMathAnomalyDetector() {
            return metricMathAnomalyDetector != null ? metricMathAnomalyDetector.toBuilder() : null;
        }

        public final void setMetricMathAnomalyDetector(MetricMathAnomalyDetector.BuilderImpl metricMathAnomalyDetector) {
            this.metricMathAnomalyDetector = metricMathAnomalyDetector != null ? metricMathAnomalyDetector.build() : null;
        }

        @Override
        public final Builder metricMathAnomalyDetector(MetricMathAnomalyDetector metricMathAnomalyDetector) {
            this.metricMathAnomalyDetector = metricMathAnomalyDetector;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAnomalyDetectorRequest build() {
            return new PutAnomalyDetectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
