/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetAlarmStateRequest extends CloudWatchRequest implements
        ToCopyableBuilder<SetAlarmStateRequest.Builder, SetAlarmStateRequest> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmName").getter(getter(SetAlarmStateRequest::alarmName)).setter(setter(Builder::alarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()).build();

    private static final SdkField<String> STATE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateValue").getter(getter(SetAlarmStateRequest::stateValueAsString))
            .setter(setter(Builder::stateValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateValue").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(SetAlarmStateRequest::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<String> STATE_REASON_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReasonData").getter(getter(SetAlarmStateRequest::stateReasonData))
            .setter(setter(Builder::stateReasonData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReasonData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD,
            STATE_VALUE_FIELD, STATE_REASON_FIELD, STATE_REASON_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String alarmName;

    private final String stateValue;

    private final String stateReason;

    private final String stateReasonData;

    private SetAlarmStateRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.stateValue = builder.stateValue;
        this.stateReason = builder.stateReason;
        this.stateReasonData = builder.stateReasonData;
    }

    /**
     * <p>
     * The name of the alarm.
     * </p>
     * 
     * @return The name of the alarm.
     */
    public final String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The value of the state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueAsString}.
     * </p>
     * 
     * @return The value of the state.
     * @see StateValue
     */
    public final StateValue stateValue() {
        return StateValue.fromValue(stateValue);
    }

    /**
     * <p>
     * The value of the state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateValue} will
     * return {@link StateValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateValueAsString}.
     * </p>
     * 
     * @return The value of the state.
     * @see StateValue
     */
    public final String stateValueAsString() {
        return stateValue;
    }

    /**
     * <p>
     * The reason that this alarm is set to this specific state, in text format.
     * </p>
     * 
     * @return The reason that this alarm is set to this specific state, in text format.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The reason that this alarm is set to this specific state, in JSON format.
     * </p>
     * <p>
     * For SNS or EC2 alarm actions, this is just informational. But for EC2 Auto Scaling or application Auto Scaling
     * alarm actions, the Auto Scaling policy uses the information in this field to take the correct action.
     * </p>
     * 
     * @return The reason that this alarm is set to this specific state, in JSON format.</p>
     *         <p>
     *         For SNS or EC2 alarm actions, this is just informational. But for EC2 Auto Scaling or application Auto
     *         Scaling alarm actions, the Auto Scaling policy uses the information in this field to take the correct
     *         action.
     */
    public final String stateReasonData() {
        return stateReasonData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(stateValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(stateReasonData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetAlarmStateRequest)) {
            return false;
        }
        SetAlarmStateRequest other = (SetAlarmStateRequest) obj;
        return Objects.equals(alarmName(), other.alarmName()) && Objects.equals(stateValueAsString(), other.stateValueAsString())
                && Objects.equals(stateReason(), other.stateReason())
                && Objects.equals(stateReasonData(), other.stateReasonData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetAlarmStateRequest").add("AlarmName", alarmName()).add("StateValue", stateValueAsString())
                .add("StateReason", stateReason()).add("StateReasonData", stateReasonData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlarmName":
            return Optional.ofNullable(clazz.cast(alarmName()));
        case "StateValue":
            return Optional.ofNullable(clazz.cast(stateValueAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "StateReasonData":
            return Optional.ofNullable(clazz.cast(stateReasonData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AlarmName", ALARM_NAME_FIELD);
        map.put("StateValue", STATE_VALUE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("StateReasonData", STATE_REASON_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetAlarmStateRequest, T> g) {
        return obj -> g.apply((SetAlarmStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetAlarmStateRequest> {
        /**
         * <p>
         * The name of the alarm.
         * </p>
         * 
         * @param alarmName
         *        The name of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The value of the state.
         * </p>
         * 
         * @param stateValue
         *        The value of the state.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(String stateValue);

        /**
         * <p>
         * The value of the state.
         * </p>
         * 
         * @param stateValue
         *        The value of the state.
         * @see StateValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateValue
         */
        Builder stateValue(StateValue stateValue);

        /**
         * <p>
         * The reason that this alarm is set to this specific state, in text format.
         * </p>
         * 
         * @param stateReason
         *        The reason that this alarm is set to this specific state, in text format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The reason that this alarm is set to this specific state, in JSON format.
         * </p>
         * <p>
         * For SNS or EC2 alarm actions, this is just informational. But for EC2 Auto Scaling or application Auto
         * Scaling alarm actions, the Auto Scaling policy uses the information in this field to take the correct action.
         * </p>
         * 
         * @param stateReasonData
         *        The reason that this alarm is set to this specific state, in JSON format.</p>
         *        <p>
         *        For SNS or EC2 alarm actions, this is just informational. But for EC2 Auto Scaling or application Auto
         *        Scaling alarm actions, the Auto Scaling policy uses the information in this field to take the correct
         *        action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReasonData(String stateReasonData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String alarmName;

        private String stateValue;

        private String stateReason;

        private String stateReasonData;

        private BuilderImpl() {
        }

        private BuilderImpl(SetAlarmStateRequest model) {
            super(model);
            alarmName(model.alarmName);
            stateValue(model.stateValue);
            stateReason(model.stateReason);
            stateReasonData(model.stateReasonData);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final String getStateValue() {
            return stateValue;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue == null ? null : stateValue.toString());
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getStateReasonData() {
            return stateReasonData;
        }

        public final void setStateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
        }

        @Override
        public final Builder stateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetAlarmStateRequest build() {
            return new SetAlarmStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
