/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutInsightRuleRequest extends CloudWatchRequest implements
        ToCopyableBuilder<PutInsightRuleRequest.Builder, PutInsightRuleRequest> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(PutInsightRuleRequest::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<String> RULE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleState").getter(getter(PutInsightRuleRequest::ruleState)).setter(setter(Builder::ruleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleState").build()).build();

    private static final SdkField<String> RULE_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleDefinition").getter(getter(PutInsightRuleRequest::ruleDefinition))
            .setter(setter(Builder::ruleDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleDefinition").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(PutInsightRuleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> APPLY_ON_TRANSFORMED_LOGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyOnTransformedLogs").getter(getter(PutInsightRuleRequest::applyOnTransformedLogs))
            .setter(setter(Builder::applyOnTransformedLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyOnTransformedLogs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            RULE_STATE_FIELD, RULE_DEFINITION_FIELD, TAGS_FIELD, APPLY_ON_TRANSFORMED_LOGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ruleName;

    private final String ruleState;

    private final String ruleDefinition;

    private final List<Tag> tags;

    private final Boolean applyOnTransformedLogs;

    private PutInsightRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.ruleState = builder.ruleState;
        this.ruleDefinition = builder.ruleDefinition;
        this.tags = builder.tags;
        this.applyOnTransformedLogs = builder.applyOnTransformedLogs;
    }

    /**
     * <p>
     * A unique name for the rule.
     * </p>
     * 
     * @return A unique name for the rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The state of the rule. Valid values are ENABLED and DISABLED.
     * </p>
     * 
     * @return The state of the rule. Valid values are ENABLED and DISABLED.
     */
    public final String ruleState() {
        return ruleState;
    }

    /**
     * <p>
     * The definition of the rule, as a JSON object. For details on the valid syntax, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html"
     * >Contributor Insights Rule Syntax</a>.
     * </p>
     * 
     * @return The definition of the rule, as a JSON object. For details on the valid syntax, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html"
     *         >Contributor Insights Rule Syntax</a>.
     */
    public final String ruleDefinition() {
        return ruleDefinition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs to associate with the Contributor Insights rule. You can associate as many as 50 tags
     * with a rule.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
     * granting a user permission to access or change only the resources that have certain tag values.
     * </p>
     * <p>
     * To be able to associate tags with a rule, you must have the <code>cloudwatch:TagResource</code> permission in
     * addition to the <code>cloudwatch:PutInsightRule</code> permission.
     * </p>
     * <p>
     * If you are using this operation to update an existing Contributor Insights rule, any tags you specify in this
     * parameter are ignored. To change the tags of an existing rule, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html">TagResource</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs to associate with the Contributor Insights rule. You can associate as many as
     *         50 tags with a rule.</p>
     *         <p>
     *         Tags can help you organize and categorize your resources. You can also use them to scope user
     *         permissions, by granting a user permission to access or change only the resources that have certain tag
     *         values.
     *         </p>
     *         <p>
     *         To be able to associate tags with a rule, you must have the <code>cloudwatch:TagResource</code>
     *         permission in addition to the <code>cloudwatch:PutInsightRule</code> permission.
     *         </p>
     *         <p>
     *         If you are using this operation to update an existing Contributor Insights rule, any tags you specify in
     *         this parameter are ignored. To change the tags of an existing rule, use <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html"
     *         >TagResource</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specify <code>true</code> to have this rule evaluate log events after they have been transformed by <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html">Log
     * transformation</a>. If you specify <code>true</code>, then the log events in log groups that have transformers
     * will be evaluated by Contributor Insights after being transformed. Log groups that don't have transformers will
     * still have their original log events evaluated by Contributor Insights.
     * </p>
     * <p>
     * The default is <code>false</code>
     * </p>
     * <note>
     * <p>
     * If a log group has a transformer, and transformation fails for some log events, those log events won't be
     * evaluated by Contributor Insights. For information about investigating log transformation failures, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Transformation-Errors-Metrics.html">Transformation
     * metrics and errors</a>.
     * </p>
     * </note>
     * 
     * @return Specify <code>true</code> to have this rule evaluate log events after they have been transformed by <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html">Log
     *         transformation</a>. If you specify <code>true</code>, then the log events in log groups that have
     *         transformers will be evaluated by Contributor Insights after being transformed. Log groups that don't
     *         have transformers will still have their original log events evaluated by Contributor Insights.</p>
     *         <p>
     *         The default is <code>false</code>
     *         </p>
     *         <note>
     *         <p>
     *         If a log group has a transformer, and transformation fails for some log events, those log events won't be
     *         evaluated by Contributor Insights. For information about investigating log transformation failures, see
     *         <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Transformation-Errors-Metrics.html">
     *         Transformation metrics and errors</a>.
     *         </p>
     */
    public final Boolean applyOnTransformedLogs() {
        return applyOnTransformedLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleState());
        hashCode = 31 * hashCode + Objects.hashCode(ruleDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applyOnTransformedLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInsightRuleRequest)) {
            return false;
        }
        PutInsightRuleRequest other = (PutInsightRuleRequest) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(ruleState(), other.ruleState())
                && Objects.equals(ruleDefinition(), other.ruleDefinition()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(applyOnTransformedLogs(), other.applyOnTransformedLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutInsightRuleRequest").add("RuleName", ruleName()).add("RuleState", ruleState())
                .add("RuleDefinition", ruleDefinition()).add("Tags", hasTags() ? tags() : null)
                .add("ApplyOnTransformedLogs", applyOnTransformedLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "RuleState":
            return Optional.ofNullable(clazz.cast(ruleState()));
        case "RuleDefinition":
            return Optional.ofNullable(clazz.cast(ruleDefinition()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ApplyOnTransformedLogs":
            return Optional.ofNullable(clazz.cast(applyOnTransformedLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("RuleState", RULE_STATE_FIELD);
        map.put("RuleDefinition", RULE_DEFINITION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ApplyOnTransformedLogs", APPLY_ON_TRANSFORMED_LOGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutInsightRuleRequest, T> g) {
        return obj -> g.apply((PutInsightRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutInsightRuleRequest> {
        /**
         * <p>
         * A unique name for the rule.
         * </p>
         * 
         * @param ruleName
         *        A unique name for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The state of the rule. Valid values are ENABLED and DISABLED.
         * </p>
         * 
         * @param ruleState
         *        The state of the rule. Valid values are ENABLED and DISABLED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleState(String ruleState);

        /**
         * <p>
         * The definition of the rule, as a JSON object. For details on the valid syntax, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html"
         * >Contributor Insights Rule Syntax</a>.
         * </p>
         * 
         * @param ruleDefinition
         *        The definition of the rule, as a JSON object. For details on the valid syntax, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html"
         *        >Contributor Insights Rule Syntax</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDefinition(String ruleDefinition);

        /**
         * <p>
         * A list of key-value pairs to associate with the Contributor Insights rule. You can associate as many as 50
         * tags with a rule.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
         * granting a user permission to access or change only the resources that have certain tag values.
         * </p>
         * <p>
         * To be able to associate tags with a rule, you must have the <code>cloudwatch:TagResource</code> permission in
         * addition to the <code>cloudwatch:PutInsightRule</code> permission.
         * </p>
         * <p>
         * If you are using this operation to update an existing Contributor Insights rule, any tags you specify in this
         * parameter are ignored. To change the tags of an existing rule, use <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html">TagResource</a>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to associate with the Contributor Insights rule. You can associate as many
         *        as 50 tags with a rule.</p>
         *        <p>
         *        Tags can help you organize and categorize your resources. You can also use them to scope user
         *        permissions, by granting a user permission to access or change only the resources that have certain
         *        tag values.
         *        </p>
         *        <p>
         *        To be able to associate tags with a rule, you must have the <code>cloudwatch:TagResource</code>
         *        permission in addition to the <code>cloudwatch:PutInsightRule</code> permission.
         *        </p>
         *        <p>
         *        If you are using this operation to update an existing Contributor Insights rule, any tags you specify
         *        in this parameter are ignored. To change the tags of an existing rule, use <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html"
         *        >TagResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs to associate with the Contributor Insights rule. You can associate as many as 50
         * tags with a rule.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
         * granting a user permission to access or change only the resources that have certain tag values.
         * </p>
         * <p>
         * To be able to associate tags with a rule, you must have the <code>cloudwatch:TagResource</code> permission in
         * addition to the <code>cloudwatch:PutInsightRule</code> permission.
         * </p>
         * <p>
         * If you are using this operation to update an existing Contributor Insights rule, any tags you specify in this
         * parameter are ignored. To change the tags of an existing rule, use <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html">TagResource</a>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to associate with the Contributor Insights rule. You can associate as many
         *        as 50 tags with a rule.</p>
         *        <p>
         *        Tags can help you organize and categorize your resources. You can also use them to scope user
         *        permissions, by granting a user permission to access or change only the resources that have certain
         *        tag values.
         *        </p>
         *        <p>
         *        To be able to associate tags with a rule, you must have the <code>cloudwatch:TagResource</code>
         *        permission in addition to the <code>cloudwatch:PutInsightRule</code> permission.
         *        </p>
         *        <p>
         *        If you are using this operation to update an existing Contributor Insights rule, any tags you specify
         *        in this parameter are ignored. To change the tags of an existing rule, use <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html"
         *        >TagResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs to associate with the Contributor Insights rule. You can associate as many as 50
         * tags with a rule.
         * </p>
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
         * granting a user permission to access or change only the resources that have certain tag values.
         * </p>
         * <p>
         * To be able to associate tags with a rule, you must have the <code>cloudwatch:TagResource</code> permission in
         * addition to the <code>cloudwatch:PutInsightRule</code> permission.
         * </p>
         * <p>
         * If you are using this operation to update an existing Contributor Insights rule, any tags you specify in this
         * parameter are ignored. To change the tags of an existing rule, use <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html">TagResource</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudwatch.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.cloudwatch.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudwatch.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudwatch.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specify <code>true</code> to have this rule evaluate log events after they have been transformed by <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html">Log
         * transformation</a>. If you specify <code>true</code>, then the log events in log groups that have
         * transformers will be evaluated by Contributor Insights after being transformed. Log groups that don't have
         * transformers will still have their original log events evaluated by Contributor Insights.
         * </p>
         * <p>
         * The default is <code>false</code>
         * </p>
         * <note>
         * <p>
         * If a log group has a transformer, and transformation fails for some log events, those log events won't be
         * evaluated by Contributor Insights. For information about investigating log transformation failures, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Transformation-Errors-Metrics.html">
         * Transformation metrics and errors</a>.
         * </p>
         * </note>
         * 
         * @param applyOnTransformedLogs
         *        Specify <code>true</code> to have this rule evaluate log events after they have been transformed by <a
         *        href
         *        ="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html">Log
         *        transformation</a>. If you specify <code>true</code>, then the log events in log groups that have
         *        transformers will be evaluated by Contributor Insights after being transformed. Log groups that don't
         *        have transformers will still have their original log events evaluated by Contributor Insights.</p>
         *        <p>
         *        The default is <code>false</code>
         *        </p>
         *        <note>
         *        <p>
         *        If a log group has a transformer, and transformation fails for some log events, those log events won't
         *        be evaluated by Contributor Insights. For information about investigating log transformation failures,
         *        see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Transformation-Errors-Metrics.html"
         *        >Transformation metrics and errors</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyOnTransformedLogs(Boolean applyOnTransformedLogs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchRequest.BuilderImpl implements Builder {
        private String ruleName;

        private String ruleState;

        private String ruleDefinition;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean applyOnTransformedLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInsightRuleRequest model) {
            super(model);
            ruleName(model.ruleName);
            ruleState(model.ruleState);
            ruleDefinition(model.ruleDefinition);
            tags(model.tags);
            applyOnTransformedLogs(model.applyOnTransformedLogs);
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getRuleState() {
            return ruleState;
        }

        public final void setRuleState(String ruleState) {
            this.ruleState = ruleState;
        }

        @Override
        public final Builder ruleState(String ruleState) {
            this.ruleState = ruleState;
            return this;
        }

        public final String getRuleDefinition() {
            return ruleDefinition;
        }

        public final void setRuleDefinition(String ruleDefinition) {
            this.ruleDefinition = ruleDefinition;
        }

        @Override
        public final Builder ruleDefinition(String ruleDefinition) {
            this.ruleDefinition = ruleDefinition;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getApplyOnTransformedLogs() {
            return applyOnTransformedLogs;
        }

        public final void setApplyOnTransformedLogs(Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
        }

        @Override
        public final Builder applyOnTransformedLogs(Boolean applyOnTransformedLogs) {
            this.applyOnTransformedLogs = applyOnTransformedLogs;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInsightRuleRequest build() {
            return new PutInsightRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
