/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a set of statistics that describes a specific metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatisticSet implements SdkPojo, Serializable, ToCopyableBuilder<StatisticSet.Builder, StatisticSet> {
    private static final SdkField<Double> SAMPLE_COUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("SampleCount").getter(getter(StatisticSet::sampleCount)).setter(setter(Builder::sampleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleCount").build()).build();

    private static final SdkField<Double> SUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Sum")
            .getter(getter(StatisticSet::sum)).setter(setter(Builder::sum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sum").build()).build();

    private static final SdkField<Double> MINIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Minimum")
            .getter(getter(StatisticSet::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Minimum").build()).build();

    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Maximum")
            .getter(getter(StatisticSet::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLE_COUNT_FIELD, SUM_FIELD,
            MINIMUM_FIELD, MAXIMUM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double sampleCount;

    private final Double sum;

    private final Double minimum;

    private final Double maximum;

    private StatisticSet(BuilderImpl builder) {
        this.sampleCount = builder.sampleCount;
        this.sum = builder.sum;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
    }

    /**
     * <p>
     * The number of samples used for the statistic set.
     * </p>
     * 
     * @return The number of samples used for the statistic set.
     */
    public final Double sampleCount() {
        return sampleCount;
    }

    /**
     * <p>
     * The sum of values for the sample set.
     * </p>
     * 
     * @return The sum of values for the sample set.
     */
    public final Double sum() {
        return sum;
    }

    /**
     * <p>
     * The minimum value of the sample set.
     * </p>
     * 
     * @return The minimum value of the sample set.
     */
    public final Double minimum() {
        return minimum;
    }

    /**
     * <p>
     * The maximum value of the sample set.
     * </p>
     * 
     * @return The maximum value of the sample set.
     */
    public final Double maximum() {
        return maximum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sampleCount());
        hashCode = 31 * hashCode + Objects.hashCode(sum());
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticSet)) {
            return false;
        }
        StatisticSet other = (StatisticSet) obj;
        return Objects.equals(sampleCount(), other.sampleCount()) && Objects.equals(sum(), other.sum())
                && Objects.equals(minimum(), other.minimum()) && Objects.equals(maximum(), other.maximum());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatisticSet").add("SampleCount", sampleCount()).add("Sum", sum()).add("Minimum", minimum())
                .add("Maximum", maximum()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SampleCount":
            return Optional.ofNullable(clazz.cast(sampleCount()));
        case "Sum":
            return Optional.ofNullable(clazz.cast(sum()));
        case "Minimum":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "Maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SampleCount", SAMPLE_COUNT_FIELD);
        map.put("Sum", SUM_FIELD);
        map.put("Minimum", MINIMUM_FIELD);
        map.put("Maximum", MAXIMUM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatisticSet, T> g) {
        return obj -> g.apply((StatisticSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatisticSet> {
        /**
         * <p>
         * The number of samples used for the statistic set.
         * </p>
         * 
         * @param sampleCount
         *        The number of samples used for the statistic set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleCount(Double sampleCount);

        /**
         * <p>
         * The sum of values for the sample set.
         * </p>
         * 
         * @param sum
         *        The sum of values for the sample set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sum(Double sum);

        /**
         * <p>
         * The minimum value of the sample set.
         * </p>
         * 
         * @param minimum
         *        The minimum value of the sample set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Double minimum);

        /**
         * <p>
         * The maximum value of the sample set.
         * </p>
         * 
         * @param maximum
         *        The maximum value of the sample set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Double maximum);
    }

    static final class BuilderImpl implements Builder {
        private Double sampleCount;

        private Double sum;

        private Double minimum;

        private Double maximum;

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticSet model) {
            sampleCount(model.sampleCount);
            sum(model.sum);
            minimum(model.minimum);
            maximum(model.maximum);
        }

        public final Double getSampleCount() {
            return sampleCount;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final Double getSum() {
            return sum;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final Double getMinimum() {
            return minimum;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final Double getMaximum() {
            return maximum;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        @Override
        public StatisticSet build() {
            return new StatisticSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
