/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.AlarmType;
import software.amazon.awssdk.services.cloudwatch.model.AlarmTypesCopier;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.HistoryItemType;
import software.amazon.awssdk.services.cloudwatch.model.ScanBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAlarmHistoryRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, DescribeAlarmHistoryRequest> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmName").getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::alarmName)).setter(DescribeAlarmHistoryRequest.setter(Builder::alarmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()}).build();
    private static final SdkField<List<String>> ALARM_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlarmTypes").getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::alarmTypesAsStrings)).setter(DescribeAlarmHistoryRequest.setter(Builder::alarmTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HISTORY_ITEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HistoryItemType").getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::historyItemTypeAsString)).setter(DescribeAlarmHistoryRequest.setter(Builder::historyItemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoryItemType").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::startDate)).setter(DescribeAlarmHistoryRequest.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::endDate)).setter(DescribeAlarmHistoryRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::maxRecords)).setter(DescribeAlarmHistoryRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::nextToken)).setter(DescribeAlarmHistoryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> SCAN_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanBy").getter(DescribeAlarmHistoryRequest.getter(DescribeAlarmHistoryRequest::scanByAsString)).setter(DescribeAlarmHistoryRequest.setter(Builder::scanBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD, ALARM_TYPES_FIELD, HISTORY_ITEM_TYPE_FIELD, START_DATE_FIELD, END_DATE_FIELD, MAX_RECORDS_FIELD, NEXT_TOKEN_FIELD, SCAN_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAlarmHistoryRequest.memberNameToFieldInitializer();
    private final String alarmName;
    private final List<String> alarmTypes;
    private final String historyItemType;
    private final Instant startDate;
    private final Instant endDate;
    private final Integer maxRecords;
    private final String nextToken;
    private final String scanBy;

    private DescribeAlarmHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.alarmTypes = builder.alarmTypes;
        this.historyItemType = builder.historyItemType;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
        this.scanBy = builder.scanBy;
    }

    public final String alarmName() {
        return this.alarmName;
    }

    public final List<AlarmType> alarmTypes() {
        return AlarmTypesCopier.copyStringToEnum(this.alarmTypes);
    }

    public final boolean hasAlarmTypes() {
        return this.alarmTypes != null && !(this.alarmTypes instanceof SdkAutoConstructList);
    }

    public final List<String> alarmTypesAsStrings() {
        return this.alarmTypes;
    }

    public final HistoryItemType historyItemType() {
        return HistoryItemType.fromValue(this.historyItemType);
    }

    public final String historyItemTypeAsString() {
        return this.historyItemType;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ScanBy scanBy() {
        return ScanBy.fromValue(this.scanBy);
    }

    public final String scanByAsString() {
        return this.scanBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmTypes() ? this.alarmTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.historyItemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanByAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmHistoryRequest)) {
            return false;
        }
        DescribeAlarmHistoryRequest other = (DescribeAlarmHistoryRequest)((Object)obj);
        return Objects.equals(this.alarmName(), other.alarmName()) && this.hasAlarmTypes() == other.hasAlarmTypes() && Objects.equals(this.alarmTypesAsStrings(), other.alarmTypesAsStrings()) && Objects.equals(this.historyItemTypeAsString(), other.historyItemTypeAsString()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.scanByAsString(), other.scanByAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAlarmHistoryRequest").add("AlarmName", (Object)this.alarmName()).add("AlarmTypes", this.hasAlarmTypes() ? this.alarmTypesAsStrings() : null).add("HistoryItemType", (Object)this.historyItemTypeAsString()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("MaxRecords", (Object)this.maxRecords()).add("NextToken", (Object)this.nextToken()).add("ScanBy", (Object)this.scanByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "AlarmTypes": {
                return Optional.ofNullable(clazz.cast(this.alarmTypesAsStrings()));
            }
            case "HistoryItemType": {
                return Optional.ofNullable(clazz.cast(this.historyItemTypeAsString()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ScanBy": {
                return Optional.ofNullable(clazz.cast(this.scanByAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AlarmName", ALARM_NAME_FIELD);
        map.put("AlarmTypes", ALARM_TYPES_FIELD);
        map.put("HistoryItemType", HISTORY_ITEM_TYPE_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ScanBy", SCAN_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmHistoryRequest, T> g) {
        return obj -> g.apply((DescribeAlarmHistoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String alarmName;
        private List<String> alarmTypes = DefaultSdkAutoConstructList.getInstance();
        private String historyItemType;
        private Instant startDate;
        private Instant endDate;
        private Integer maxRecords;
        private String nextToken;
        private String scanBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmHistoryRequest model) {
            super(model);
            this.alarmName(model.alarmName);
            this.alarmTypesWithStrings(model.alarmTypes);
            this.historyItemType(model.historyItemType);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.maxRecords(model.maxRecords);
            this.nextToken(model.nextToken);
            this.scanBy(model.scanBy);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final Collection<String> getAlarmTypes() {
            if (this.alarmTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alarmTypes;
        }

        public final void setAlarmTypes(Collection<String> alarmTypes) {
            this.alarmTypes = AlarmTypesCopier.copy(alarmTypes);
        }

        @Override
        public final Builder alarmTypesWithStrings(Collection<String> alarmTypes) {
            this.alarmTypes = AlarmTypesCopier.copy(alarmTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmTypesWithStrings(String ... alarmTypes) {
            this.alarmTypesWithStrings(Arrays.asList(alarmTypes));
            return this;
        }

        @Override
        public final Builder alarmTypes(Collection<AlarmType> alarmTypes) {
            this.alarmTypes = AlarmTypesCopier.copyEnumToString(alarmTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmTypes(AlarmType ... alarmTypes) {
            this.alarmTypes(Arrays.asList(alarmTypes));
            return this;
        }

        public final String getHistoryItemType() {
            return this.historyItemType;
        }

        public final void setHistoryItemType(String historyItemType) {
            this.historyItemType = historyItemType;
        }

        @Override
        public final Builder historyItemType(String historyItemType) {
            this.historyItemType = historyItemType;
            return this;
        }

        @Override
        public final Builder historyItemType(HistoryItemType historyItemType) {
            this.historyItemType(historyItemType == null ? null : historyItemType.toString());
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getScanBy() {
            return this.scanBy;
        }

        public final void setScanBy(String scanBy) {
            this.scanBy = scanBy;
        }

        @Override
        public final Builder scanBy(String scanBy) {
            this.scanBy = scanBy;
            return this;
        }

        @Override
        public final Builder scanBy(ScanBy scanBy) {
            this.scanBy(scanBy == null ? null : scanBy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAlarmHistoryRequest build() {
            return new DescribeAlarmHistoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAlarmHistoryRequest> {
        public Builder alarmName(String var1);

        public Builder alarmTypesWithStrings(Collection<String> var1);

        public Builder alarmTypesWithStrings(String ... var1);

        public Builder alarmTypes(Collection<AlarmType> var1);

        public Builder alarmTypes(AlarmType ... var1);

        public Builder historyItemType(String var1);

        public Builder historyItemType(HistoryItemType var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);

        public Builder scanBy(String var1);

        public Builder scanBy(ScanBy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

