/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatch.model.DatapointValueMapCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Datapoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Datapoint> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(Datapoint.getter(Datapoint::timestamp)).setter(Datapoint.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<Double> SAMPLE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SampleCount").getter(Datapoint.getter(Datapoint::sampleCount)).setter(Datapoint.setter(Builder::sampleCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleCount").build()}).build();
    private static final SdkField<Double> AVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Average").getter(Datapoint.getter(Datapoint::average)).setter(Datapoint.setter(Builder::average)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Average").build()}).build();
    private static final SdkField<Double> SUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Sum").getter(Datapoint.getter(Datapoint::sum)).setter(Datapoint.setter(Builder::sum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sum").build()}).build();
    private static final SdkField<Double> MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Minimum").getter(Datapoint.getter(Datapoint::minimum)).setter(Datapoint.setter(Builder::minimum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Minimum").build()}).build();
    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Maximum").getter(Datapoint.getter(Datapoint::maximum)).setter(Datapoint.setter(Builder::maximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(Datapoint.getter(Datapoint::unitAsString)).setter(Datapoint.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final SdkField<Map<String, Double>> EXTENDED_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ExtendedStatistics").getter(Datapoint.getter(Datapoint::extendedStatistics)).setter(Datapoint.setter(Builder::extendedStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedStatistics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, SAMPLE_COUNT_FIELD, AVERAGE_FIELD, SUM_FIELD, MINIMUM_FIELD, MAXIMUM_FIELD, UNIT_FIELD, EXTENDED_STATISTICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Datapoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final Double sampleCount;
    private final Double average;
    private final Double sum;
    private final Double minimum;
    private final Double maximum;
    private final String unit;
    private final Map<String, Double> extendedStatistics;

    private Datapoint(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.sampleCount = builder.sampleCount;
        this.average = builder.average;
        this.sum = builder.sum;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.unit = builder.unit;
        this.extendedStatistics = builder.extendedStatistics;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final Double sampleCount() {
        return this.sampleCount;
    }

    public final Double average() {
        return this.average;
    }

    public final Double sum() {
        return this.sum;
    }

    public final Double minimum() {
        return this.minimum;
    }

    public final Double maximum() {
        return this.maximum;
    }

    public final StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final boolean hasExtendedStatistics() {
        return this.extendedStatistics != null && !(this.extendedStatistics instanceof SdkAutoConstructMap);
    }

    public final Map<String, Double> extendedStatistics() {
        return this.extendedStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.average());
        hashCode = 31 * hashCode + Objects.hashCode(this.sum());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtendedStatistics() ? this.extendedStatistics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Datapoint)) {
            return false;
        }
        Datapoint other = (Datapoint)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.sampleCount(), other.sampleCount()) && Objects.equals(this.average(), other.average()) && Objects.equals(this.sum(), other.sum()) && Objects.equals(this.minimum(), other.minimum()) && Objects.equals(this.maximum(), other.maximum()) && Objects.equals(this.unitAsString(), other.unitAsString()) && this.hasExtendedStatistics() == other.hasExtendedStatistics() && Objects.equals(this.extendedStatistics(), other.extendedStatistics());
    }

    public final String toString() {
        return ToString.builder((String)"Datapoint").add("Timestamp", (Object)this.timestamp()).add("SampleCount", (Object)this.sampleCount()).add("Average", (Object)this.average()).add("Sum", (Object)this.sum()).add("Minimum", (Object)this.minimum()).add("Maximum", (Object)this.maximum()).add("Unit", (Object)this.unitAsString()).add("ExtendedStatistics", this.hasExtendedStatistics() ? this.extendedStatistics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "SampleCount": {
                return Optional.ofNullable(clazz.cast(this.sampleCount()));
            }
            case "Average": {
                return Optional.ofNullable(clazz.cast(this.average()));
            }
            case "Sum": {
                return Optional.ofNullable(clazz.cast(this.sum()));
            }
            case "Minimum": {
                return Optional.ofNullable(clazz.cast(this.minimum()));
            }
            case "Maximum": {
                return Optional.ofNullable(clazz.cast(this.maximum()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "ExtendedStatistics": {
                return Optional.ofNullable(clazz.cast(this.extendedStatistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("SampleCount", SAMPLE_COUNT_FIELD);
        map.put("Average", AVERAGE_FIELD);
        map.put("Sum", SUM_FIELD);
        map.put("Minimum", MINIMUM_FIELD);
        map.put("Maximum", MAXIMUM_FIELD);
        map.put("Unit", UNIT_FIELD);
        map.put("ExtendedStatistics", EXTENDED_STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Datapoint, T> g) {
        return obj -> g.apply((Datapoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private Double sampleCount;
        private Double average;
        private Double sum;
        private Double minimum;
        private Double maximum;
        private String unit;
        private Map<String, Double> extendedStatistics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Datapoint model) {
            this.timestamp(model.timestamp);
            this.sampleCount(model.sampleCount);
            this.average(model.average);
            this.sum(model.sum);
            this.minimum(model.minimum);
            this.maximum(model.maximum);
            this.unit(model.unit);
            this.extendedStatistics(model.extendedStatistics);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Double getSampleCount() {
            return this.sampleCount;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final Double getAverage() {
            return this.average;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final Double getSum() {
            return this.sum;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final Double getMinimum() {
            return this.minimum;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final Double getMaximum() {
            return this.maximum;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Map<String, Double> getExtendedStatistics() {
            if (this.extendedStatistics instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.extendedStatistics;
        }

        public final void setExtendedStatistics(Map<String, Double> extendedStatistics) {
            this.extendedStatistics = DatapointValueMapCopier.copy(extendedStatistics);
        }

        @Override
        public final Builder extendedStatistics(Map<String, Double> extendedStatistics) {
            this.extendedStatistics = DatapointValueMapCopier.copy(extendedStatistics);
            return this;
        }

        public Datapoint build() {
            return new Datapoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Datapoint> {
        public Builder timestamp(Instant var1);

        public Builder sampleCount(Double var1);

        public Builder average(Double var1);

        public Builder sum(Double var1);

        public Builder minimum(Double var1);

        public Builder maximum(Double var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);

        public Builder extendedStatistics(Map<String, Double> var1);
    }
}

