/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse;

public class ListMetricStreamsPublisher
implements SdkPublisher<ListMetricStreamsResponse> {
    private final CloudWatchAsyncClient client;
    private final ListMetricStreamsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMetricStreamsPublisher(CloudWatchAsyncClient client, ListMetricStreamsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMetricStreamsPublisher(CloudWatchAsyncClient client, ListMetricStreamsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMetricStreamsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMetricStreamsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMetricStreamsResponseFetcher
    implements AsyncPageFetcher<ListMetricStreamsResponse> {
        private ListMetricStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricStreamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMetricStreamsResponse> nextPage(ListMetricStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListMetricStreamsPublisher.this.client.listMetricStreams(ListMetricStreamsPublisher.this.firstRequest);
            }
            return ListMetricStreamsPublisher.this.client.listMetricStreams((ListMetricStreamsRequest)((Object)ListMetricStreamsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

