/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatch.model.MetricStat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricDataQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricDataQuery> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(MetricDataQuery.getter(MetricDataQuery::id)).setter(MetricDataQuery.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<MetricStat> METRIC_STAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricStat").getter(MetricDataQuery.getter(MetricDataQuery::metricStat)).setter(MetricDataQuery.setter(Builder::metricStat)).constructor(MetricStat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricStat").build()}).build();
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expression").getter(MetricDataQuery.getter(MetricDataQuery::expression)).setter(MetricDataQuery.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(MetricDataQuery.getter(MetricDataQuery::label)).setter(MetricDataQuery.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<Boolean> RETURN_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReturnData").getter(MetricDataQuery.getter(MetricDataQuery::returnData)).setter(MetricDataQuery.setter(Builder::returnData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnData").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Period").getter(MetricDataQuery.getter(MetricDataQuery::period)).setter(MetricDataQuery.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(MetricDataQuery.getter(MetricDataQuery::accountId)).setter(MetricDataQuery.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, METRIC_STAT_FIELD, EXPRESSION_FIELD, LABEL_FIELD, RETURN_DATA_FIELD, PERIOD_FIELD, ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricDataQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final MetricStat metricStat;
    private final String expression;
    private final String label;
    private final Boolean returnData;
    private final Integer period;
    private final String accountId;

    private MetricDataQuery(BuilderImpl builder) {
        this.id = builder.id;
        this.metricStat = builder.metricStat;
        this.expression = builder.expression;
        this.label = builder.label;
        this.returnData = builder.returnData;
        this.period = builder.period;
        this.accountId = builder.accountId;
    }

    public final String id() {
        return this.id;
    }

    public final MetricStat metricStat() {
        return this.metricStat;
    }

    public final String expression() {
        return this.expression;
    }

    public final String label() {
        return this.label;
    }

    public final Boolean returnData() {
        return this.returnData;
    }

    public final Integer period() {
        return this.period;
    }

    public final String accountId() {
        return this.accountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricStat());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnData());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDataQuery)) {
            return false;
        }
        MetricDataQuery other = (MetricDataQuery)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.metricStat(), other.metricStat()) && Objects.equals(this.expression(), other.expression()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.returnData(), other.returnData()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.accountId(), other.accountId());
    }

    public final String toString() {
        return ToString.builder((String)"MetricDataQuery").add("Id", (Object)this.id()).add("MetricStat", (Object)this.metricStat()).add("Expression", (Object)this.expression()).add("Label", (Object)this.label()).add("ReturnData", (Object)this.returnData()).add("Period", (Object)this.period()).add("AccountId", (Object)this.accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "MetricStat": {
                return Optional.ofNullable(clazz.cast(this.metricStat()));
            }
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "ReturnData": {
                return Optional.ofNullable(clazz.cast(this.returnData()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("MetricStat", METRIC_STAT_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        map.put("Label", LABEL_FIELD);
        map.put("ReturnData", RETURN_DATA_FIELD);
        map.put("Period", PERIOD_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricDataQuery, T> g) {
        return obj -> g.apply((MetricDataQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private MetricStat metricStat;
        private String expression;
        private String label;
        private Boolean returnData;
        private Integer period;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDataQuery model) {
            this.id(model.id);
            this.metricStat(model.metricStat);
            this.expression(model.expression);
            this.label(model.label);
            this.returnData(model.returnData);
            this.period(model.period);
            this.accountId(model.accountId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MetricStat.Builder getMetricStat() {
            return this.metricStat != null ? this.metricStat.toBuilder() : null;
        }

        public final void setMetricStat(MetricStat.BuilderImpl metricStat) {
            this.metricStat = metricStat != null ? metricStat.build() : null;
        }

        @Override
        public final Builder metricStat(MetricStat metricStat) {
            this.metricStat = metricStat;
            return this;
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Boolean getReturnData() {
            return this.returnData;
        }

        public final void setReturnData(Boolean returnData) {
            this.returnData = returnData;
        }

        @Override
        public final Builder returnData(Boolean returnData) {
            this.returnData = returnData;
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public MetricDataQuery build() {
            return new MetricDataQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricDataQuery> {
        public Builder id(String var1);

        public Builder metricStat(MetricStat var1);

        default public Builder metricStat(Consumer<MetricStat.Builder> metricStat) {
            return this.metricStat((MetricStat)((MetricStat.Builder)MetricStat.builder().applyMutation(metricStat)).build());
        }

        public Builder expression(String var1);

        public Builder label(String var1);

        public Builder returnData(Boolean var1);

        public Builder period(Integer var1);

        public Builder accountId(String var1);
    }
}

