/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage;

public class DashboardValidationMessageUnmarshaller
implements Unmarshaller<DashboardValidationMessage, StaxUnmarshallerContext> {
    private static final DashboardValidationMessageUnmarshaller INSTANCE = new DashboardValidationMessageUnmarshaller();

    public DashboardValidationMessage unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DashboardValidationMessage.Builder dashboardValidationMessage = DashboardValidationMessage.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DataPath", targetDepth)) {
                    dashboardValidationMessage.dataPath(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Message", targetDepth)) continue;
                dashboardValidationMessage.message(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DashboardValidationMessage)dashboardValidationMessage.build();
    }

    public static DashboardValidationMessageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

