/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DashboardEntry
implements ToCopyableBuilder<Builder, DashboardEntry> {
    private final String dashboardName;
    private final String dashboardArn;
    private final Instant lastModified;
    private final Long size;

    private DashboardEntry(BuilderImpl builder) {
        this.dashboardName = builder.dashboardName;
        this.dashboardArn = builder.dashboardArn;
        this.lastModified = builder.lastModified;
        this.size = builder.size;
    }

    public String dashboardName() {
        return this.dashboardName;
    }

    public String dashboardArn() {
        return this.dashboardArn;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public Long size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardEntry)) {
            return false;
        }
        DashboardEntry other = (DashboardEntry)obj;
        return Objects.equals(this.dashboardName(), other.dashboardName()) && Objects.equals(this.dashboardArn(), other.dashboardArn()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.size(), other.size());
    }

    public String toString() {
        return ToString.builder((String)"DashboardEntry").add("DashboardName", (Object)this.dashboardName()).add("DashboardArn", (Object)this.dashboardArn()).add("LastModified", (Object)this.lastModified()).add("Size", (Object)this.size()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardName": {
                return Optional.of(clazz.cast(this.dashboardName()));
            }
            case "DashboardArn": {
                return Optional.of(clazz.cast(this.dashboardArn()));
            }
            case "LastModified": {
                return Optional.of(clazz.cast(this.lastModified()));
            }
            case "Size": {
                return Optional.of(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dashboardName;
        private String dashboardArn;
        private Instant lastModified;
        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardEntry model) {
            this.dashboardName(model.dashboardName);
            this.dashboardArn(model.dashboardArn);
            this.lastModified(model.lastModified);
            this.size(model.size);
        }

        public final String getDashboardName() {
            return this.dashboardName;
        }

        @Override
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        public final String getDashboardArn() {
            return this.dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public DashboardEntry build() {
            return new DashboardEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DashboardEntry> {
        public Builder dashboardName(String var1);

        public Builder dashboardArn(String var1);

        public Builder lastModified(Instant var1);

        public Builder size(Long var1);
    }
}

