/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarm;

public final class DescribeAlarmsPaginator
implements SdkIterable<DescribeAlarmsResponse> {
    private final CloudWatchClient client;
    private final DescribeAlarmsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeAlarmsPaginator(CloudWatchClient client, DescribeAlarmsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAlarmsResponseFetcher();
    }

    public Iterator<DescribeAlarmsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<MetricAlarm> metricAlarms() {
        Function<DescribeAlarmsResponse, Iterator> getIterator = response -> response != null ? response.metricAlarms().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeAlarmsResponseFetcher
    implements NextPageFetcher<DescribeAlarmsResponse> {
        private DescribeAlarmsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAlarmsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeAlarmsResponse nextPage(DescribeAlarmsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAlarmsPaginator.this.client.describeAlarms(DescribeAlarmsPaginator.this.firstRequest);
            }
            return DescribeAlarmsPaginator.this.client.describeAlarms((DescribeAlarmsRequest)((Object)DescribeAlarmsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

