/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutDashboardRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, PutDashboardRequest> {
    private final String dashboardName;
    private final String dashboardBody;

    private PutDashboardRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardName = builder.dashboardName;
        this.dashboardBody = builder.dashboardBody;
    }

    public String dashboardName() {
        return this.dashboardName;
    }

    public String dashboardBody() {
        return this.dashboardBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardBody());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDashboardRequest)) {
            return false;
        }
        PutDashboardRequest other = (PutDashboardRequest)((Object)obj);
        return Objects.equals(this.dashboardName(), other.dashboardName()) && Objects.equals(this.dashboardBody(), other.dashboardBody());
    }

    public String toString() {
        return ToString.builder((String)"PutDashboardRequest").add("DashboardName", (Object)this.dashboardName()).add("DashboardBody", (Object)this.dashboardBody()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardName": {
                return Optional.of(clazz.cast(this.dashboardName()));
            }
            case "DashboardBody": {
                return Optional.of(clazz.cast(this.dashboardBody()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String dashboardName;
        private String dashboardBody;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDashboardRequest model) {
            this.dashboardName(model.dashboardName);
            this.dashboardBody(model.dashboardBody);
        }

        public final String getDashboardName() {
            return this.dashboardName;
        }

        @Override
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        public final String getDashboardBody() {
            return this.dashboardBody;
        }

        @Override
        public final Builder dashboardBody(String dashboardBody) {
            this.dashboardBody = dashboardBody;
            return this;
        }

        public final void setDashboardBody(String dashboardBody) {
            this.dashboardBody = dashboardBody;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutDashboardRequest build() {
            return new PutDashboardRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    CopyableBuilder<Builder, PutDashboardRequest> {
        public Builder dashboardName(String var1);

        public Builder dashboardBody(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

