/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StateValue {
    OK("OK"),
    ALARM("ALARM"),
    INSUFFICIENT_DATA("INSUFFICIENT_DATA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StateValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StateValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StateValue.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StateValue> knownValues() {
        return Stream.of(StateValue.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

